/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth;

import com.fasterxml.jackson.annotation.JsonProperty;

public class OAuthTokenErrorResponse {
    private final String error;
    private final String errorDescription;
    private final String errorUri;

    public OAuthTokenErrorResponse(Error error) {
        this.error = error.name();
        this.errorDescription = error.getErrorDescription();
        this.errorUri = null;
    }

    @JsonProperty(value="error")
    public String getError() {
        return this.error;
    }

    @JsonProperty(value="error_description")
    public String getErrorDescription() {
        return this.errorDescription;
    }

    @JsonProperty(value="error_uri")
    public String getErrorUri() {
        return this.errorUri;
    }

    public static enum Error {
        invalid_request("The request is invalid"),
        invalid_client("The Client is invalid"),
        invalid_grant("The grant is invalid"),
        unauthorized_client("The client is not authorized"),
        unsupported_grant_type("The grant type is invalid"),
        invalid_scope("The scope is invalid");

        final String errorDescription;

        private Error(String errorDescription) {
            this.errorDescription = errorDescription;
        }

        public String getErrorDescription() {
            return this.errorDescription;
        }
    }
}

