/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.io;

import jakarta.annotation.Nonnull;
import jakarta.enterprise.inject.Vetoed;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.io.FileIO;
import org.apache.polaris.core.config.PolarisConfigurationStore;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.persistence.MetaStoreManagerFactory;
import org.apache.polaris.core.persistence.PolarisResolvedPathWrapper;
import org.apache.polaris.core.storage.PolarisStorageActions;
import org.apache.polaris.service.catalog.io.DefaultFileIOFactory;
import org.apache.polaris.service.catalog.io.FileIOFactory;
import org.apache.polaris.service.catalog.io.MeasuredFileIO;
import org.apache.polaris.service.config.RealmEntityManagerFactory;

@Vetoed
public class MeasuredFileIOFactory
implements FileIOFactory {
    private final List<MeasuredFileIO> ios = new ArrayList<MeasuredFileIO>();
    public Optional<Supplier<RuntimeException>> loadFileIOExceptionSupplier = Optional.empty();
    public Optional<Supplier<RuntimeException>> newInputFileExceptionSupplier = Optional.empty();
    public Optional<Supplier<RuntimeException>> newOutputFileExceptionSupplier = Optional.empty();
    public Optional<Supplier<RuntimeException>> getLengthExceptionSupplier = Optional.empty();
    private final FileIOFactory defaultFileIOFactory;

    @Inject
    public MeasuredFileIOFactory(RealmEntityManagerFactory realmEntityManagerFactory, MetaStoreManagerFactory metaStoreManagerFactory, PolarisConfigurationStore configurationStore) {
        this.defaultFileIOFactory = new DefaultFileIOFactory(realmEntityManagerFactory, metaStoreManagerFactory, configurationStore);
    }

    public FileIO loadFileIO(@Nonnull CallContext callContext, @Nonnull String ioImplClassName, @Nonnull Map<String, String> properties, @Nonnull TableIdentifier identifier, @Nonnull Set<String> tableLocations, @Nonnull Set<PolarisStorageActions> storageActions, @Nonnull PolarisResolvedPathWrapper resolvedEntityPath) {
        this.loadFileIOExceptionSupplier.ifPresent(s -> {
            throw (RuntimeException)s.get();
        });
        MeasuredFileIO wrapped = new MeasuredFileIO(this.defaultFileIOFactory.loadFileIO(callContext, ioImplClassName, properties, identifier, tableLocations, storageActions, resolvedEntityPath), this.newInputFileExceptionSupplier, this.newOutputFileExceptionSupplier, this.getLengthExceptionSupplier);
        this.ios.add(wrapped);
        return wrapped;
    }

    public long getInputBytes() {
        long sum = 0L;
        for (MeasuredFileIO io : this.ios) {
            sum += io.getInputBytes();
        }
        return sum;
    }

    public long getNumOutputFiles() {
        long sum = 0L;
        for (MeasuredFileIO io : this.ios) {
            sum += (long)io.getNumOuptutFiles();
        }
        return sum;
    }

    public long getNumDeletedFiles() {
        long sum = 0L;
        for (MeasuredFileIO io : this.ios) {
            sum += (long)io.getNumDeletedFiles();
        }
        return sum;
    }
}

