/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.io;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.polaris.service.catalog.io.MeasuredInputFile;

public class MeasuredFileIO
implements FileIO {
    private final FileIO io;
    private final Optional<Supplier<RuntimeException>> newInputFileExceptionSupplier;
    private final Optional<Supplier<RuntimeException>> newOutputFileExceptionSupplier;
    private final Optional<Supplier<RuntimeException>> getLengthExceptionSupplier;
    private long inputBytes;
    private int numOutputFiles;
    private int numDeletedFiles;

    public MeasuredFileIO(FileIO io, Optional<Supplier<RuntimeException>> newInputFileExceptionSupplier, Optional<Supplier<RuntimeException>> newOutputFileExceptionSupplier, Optional<Supplier<RuntimeException>> getLengthExceptionSupplier) {
        this.io = io;
        this.newInputFileExceptionSupplier = newInputFileExceptionSupplier;
        this.newOutputFileExceptionSupplier = newOutputFileExceptionSupplier;
        this.getLengthExceptionSupplier = getLengthExceptionSupplier;
    }

    public long getInputBytes() {
        return this.inputBytes;
    }

    public int getNumOuptutFiles() {
        return this.numOutputFiles;
    }

    public int getNumDeletedFiles() {
        return this.numDeletedFiles;
    }

    private InputFile wrapInputFile(InputFile inner) {
        this.newInputFileExceptionSupplier.ifPresent(s -> {
            throw (RuntimeException)s.get();
        });
        this.inputBytes += inner.getLength();
        return new MeasuredInputFile(inner, this.getLengthExceptionSupplier);
    }

    public InputFile newInputFile(String path) {
        return this.wrapInputFile(this.io.newInputFile(path));
    }

    public InputFile newInputFile(String path, long length) {
        return this.wrapInputFile(this.io.newInputFile(path, length));
    }

    public InputFile newInputFile(DataFile file) {
        return this.wrapInputFile(this.io.newInputFile(file));
    }

    public InputFile newInputFile(DeleteFile file) {
        return this.wrapInputFile(this.io.newInputFile(file));
    }

    public InputFile newInputFile(ManifestFile manifest) {
        return this.wrapInputFile(this.io.newInputFile(manifest));
    }

    public OutputFile newOutputFile(String path) {
        this.newOutputFileExceptionSupplier.ifPresent(s -> {
            throw (RuntimeException)s.get();
        });
        ++this.numOutputFiles;
        return this.io.newOutputFile(path);
    }

    public void deleteFile(String path) {
        ++this.numDeletedFiles;
        this.io.deleteFile(path);
    }

    public void deleteFile(InputFile file) {
        ++this.numDeletedFiles;
        this.io.deleteFile(file);
    }

    public void deleteFile(OutputFile file) {
        ++this.numDeletedFiles;
        this.io.deleteFile(file);
    }

    public Map<String, String> properties() {
        return this.io.properties();
    }

    public void initialize(Map<String, String> properties) {
        this.io.initialize(properties);
    }

    public void close() {
        this.io.close();
    }
}

