/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog;

import jakarta.ws.rs.core.SecurityContext;
import java.util.Arrays;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.polaris.core.catalog.PolarisCatalogHelpers;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.persistence.PolarisEntityManager;
import org.apache.polaris.core.persistence.PolarisResolvedPathWrapper;
import org.apache.polaris.core.persistence.resolver.PolarisResolutionManifest;
import org.apache.polaris.core.persistence.resolver.PolarisResolutionManifestCatalogView;
import org.apache.polaris.core.persistence.resolver.ResolverPath;
import org.apache.polaris.service.types.PolicyIdentifier;

public class PolarisPassthroughResolutionView
implements PolarisResolutionManifestCatalogView {
    private final PolarisEntityManager entityManager;
    private final CallContext callContext;
    private final SecurityContext securityContext;
    private final String catalogName;

    public PolarisPassthroughResolutionView(CallContext callContext, PolarisEntityManager entityManager, SecurityContext securityContext, String catalogName) {
        this.entityManager = entityManager;
        this.callContext = callContext;
        this.securityContext = securityContext;
        this.catalogName = catalogName;
    }

    public PolarisResolvedPathWrapper getResolvedReferenceCatalogEntity() {
        PolarisResolutionManifest manifest = this.entityManager.prepareResolutionManifest(this.callContext, this.securityContext, this.catalogName);
        manifest.resolveAll();
        return manifest.getResolvedReferenceCatalogEntity();
    }

    public PolarisResolvedPathWrapper getResolvedPath(Object key) {
        PolarisResolutionManifest manifest = this.entityManager.prepareResolutionManifest(this.callContext, this.securityContext, this.catalogName);
        if (key instanceof Namespace) {
            Namespace namespace = (Namespace)key;
            manifest.addPath(new ResolverPath(Arrays.asList(namespace.levels()), PolarisEntityType.NAMESPACE), (Object)namespace);
            manifest.resolveAll();
            return manifest.getResolvedPath((Object)namespace);
        }
        throw new IllegalStateException(String.format("Trying to getResolvedPath(key) for %s with class %s", key, key.getClass()));
    }

    public PolarisResolvedPathWrapper getResolvedPath(Object key, PolarisEntityType entityType, PolarisEntitySubType subType) {
        PolarisResolutionManifest manifest = this.entityManager.prepareResolutionManifest(this.callContext, this.securityContext, this.catalogName);
        if (key instanceof TableIdentifier) {
            TableIdentifier identifier = (TableIdentifier)key;
            manifest.addPath(new ResolverPath(PolarisCatalogHelpers.tableIdentifierToList((TableIdentifier)identifier), entityType), (Object)identifier);
            manifest.resolveAll();
            return manifest.getResolvedPath((Object)identifier, entityType, subType);
        }
        if (key instanceof PolicyIdentifier) {
            PolicyIdentifier policyIdentifier = (PolicyIdentifier)key;
            manifest.addPath(new ResolverPath(PolarisCatalogHelpers.identifierToList((Namespace)policyIdentifier.getNamespace(), (String)policyIdentifier.getName()), entityType), (Object)policyIdentifier);
            manifest.resolveAll();
            return manifest.getResolvedPath((Object)policyIdentifier, entityType, subType);
        }
        throw new IllegalStateException(String.format("Trying to getResolvedPath(key, subType) for %s with class %s and type %s / %s", key, key.getClass(), entityType, subType));
    }

    public PolarisResolvedPathWrapper getPassthroughResolvedPath(Object key) {
        PolarisResolutionManifest manifest = this.entityManager.prepareResolutionManifest(this.callContext, this.securityContext, this.catalogName);
        if (key instanceof Namespace) {
            Namespace namespace = (Namespace)key;
            manifest.addPassthroughPath(new ResolverPath(Arrays.asList(namespace.levels()), PolarisEntityType.NAMESPACE), (Object)namespace);
            return manifest.getPassthroughResolvedPath((Object)namespace);
        }
        throw new IllegalStateException(String.format("Trying to getResolvedPath(key) for %s with class %s", key, key.getClass()));
    }

    public PolarisResolvedPathWrapper getPassthroughResolvedPath(Object key, PolarisEntityType entityType, PolarisEntitySubType subType) {
        PolarisResolutionManifest manifest = this.entityManager.prepareResolutionManifest(this.callContext, this.securityContext, this.catalogName);
        if (key instanceof TableIdentifier) {
            TableIdentifier identifier = (TableIdentifier)key;
            manifest.addPassthroughPath(new ResolverPath(PolarisCatalogHelpers.tableIdentifierToList((TableIdentifier)identifier), entityType), (Object)identifier);
            return manifest.getPassthroughResolvedPath((Object)identifier, entityType, subType);
        }
        if (key instanceof PolicyIdentifier) {
            PolicyIdentifier policyIdentifier = (PolicyIdentifier)key;
            manifest.addPassthroughPath(new ResolverPath(PolarisCatalogHelpers.identifierToList((Namespace)policyIdentifier.getNamespace(), (String)policyIdentifier.getName()), entityType), (Object)policyIdentifier);
            return manifest.getPassthroughResolvedPath((Object)policyIdentifier, entityType, subType);
        }
        throw new IllegalStateException(String.format("Trying to getResolvedPath(key, subType) for %s with class %s and subType %s", key, key.getClass(), subType));
    }
}

