/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.quarkus.auth.internal;

import io.quarkus.security.credential.Credential;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import java.security.Principal;
import org.apache.polaris.service.quarkus.auth.internal.InternalAuthenticationMechanism;

@ApplicationScoped
class InternalIdentityProvider
implements IdentityProvider<TokenAuthenticationRequest> {
    InternalIdentityProvider() {
    }

    public Class<TokenAuthenticationRequest> getRequestType() {
        return TokenAuthenticationRequest.class;
    }

    public Uni<SecurityIdentity> authenticate(TokenAuthenticationRequest request, AuthenticationRequestContext context) {
        TokenCredential tokenCredential = request.getToken();
        if (!(tokenCredential instanceof InternalAuthenticationMechanism.InternalPrincipalAuthInfo)) {
            return Uni.createFrom().nullItem();
        }
        InternalAuthenticationMechanism.InternalPrincipalAuthInfo credential = (InternalAuthenticationMechanism.InternalPrincipalAuthInfo)tokenCredential;
        InternalTokenPrincipal principal = new InternalTokenPrincipal(credential.getPrincipalName());
        return Uni.createFrom().item((Object)QuarkusSecurityIdentity.builder().setPrincipal((Principal)principal).addCredential((Credential)credential).addAttribute(RoutingContext.class.getName(), (Object)HttpSecurityUtils.getRoutingContextAttribute((AuthenticationRequest)request)).build());
    }

    private record InternalTokenPrincipal(String getName) implements Principal
    {
    }
}

