/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.quarkus.auth.external;

import io.smallrye.config.WithDefault;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public interface OidcTenantConfiguration {
    public PrincipalMapper principalMapper();

    public PrincipalRolesMapper principalRolesMapper();

    public static interface PrincipalRolesMapper {
        @WithDefault(value="default")
        public String type();

        public Optional<String> filter();

        public List<RegexMapping> mappings();

        default public Predicate<String> filterPredicate() {
            return role -> this.filter().isEmpty() || role.matches(this.filter().get());
        }

        default public Function<String, String> mapperFunction() {
            return role -> {
                for (RegexMapping mapping : this.mappings()) {
                    role = mapping.replace((String)role);
                }
                return role;
            };
        }

        public static interface RegexMapping {
            public String regex();

            public String replacement();

            default public String replace(String role) {
                return role.replaceAll(this.regex(), this.replacement());
            }
        }
    }

    public static interface PrincipalMapper {
        public Optional<String> idClaimPath();

        public Optional<String> nameClaimPath();

        @WithDefault(value="default")
        public String type();
    }
}

