/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.persistence.relational.jdbc;

import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.polaris.core.entity.PolarisEntityCore;
import org.apache.polaris.core.entity.PolarisEntityId;
import org.apache.polaris.core.storage.StorageLocation;
import org.apache.polaris.persistence.relational.jdbc.models.ModelEntity;

public class QueryGenerator {
    public static PreparedQuery generateSelectQuery(@Nonnull List<String> projections, @Nonnull String tableName, @Nonnull Map<String, Object> whereClause) {
        QueryFragment where = QueryGenerator.generateWhereClause(new HashSet<String>(projections), whereClause);
        PreparedQuery query = QueryGenerator.generateSelectQuery(projections, tableName, where.sql());
        return new PreparedQuery(query.sql(), where.parameters());
    }

    public static PreparedQuery generateDeleteQueryForEntityGrantRecords(@Nonnull PolarisEntityCore entity, @Nonnull String realmId) {
        String where = " WHERE (\n    (grantee_id = ? AND grantee_catalog_id = ?) OR\n    (securable_id = ? AND securable_catalog_id = ?)\n) AND realm_id = ?";
        List<Object> params = Arrays.asList(entity.getId(), entity.getCatalogId(), entity.getId(), entity.getCatalogId(), realmId);
        return new PreparedQuery("DELETE FROM " + QueryGenerator.getFullyQualifiedTableName("GRANT_RECORDS") + where, params);
    }

    public static PreparedQuery generateSelectQueryWithEntityIds(@Nonnull String realmId, @Nonnull List<PolarisEntityId> entityIds) {
        if (entityIds.isEmpty()) {
            throw new IllegalArgumentException("Empty entity ids");
        }
        String placeholders = entityIds.stream().map(e -> "(?, ?)").collect(Collectors.joining(", "));
        ArrayList<Object> params = new ArrayList<Object>();
        for (PolarisEntityId id : entityIds) {
            params.add(id.getCatalogId());
            params.add(id.getId());
        }
        params.add(realmId);
        String where = " WHERE (catalog_id, id) IN (" + placeholders + ") AND realm_id = ?";
        return new PreparedQuery(QueryGenerator.generateSelectQuery(ModelEntity.ALL_COLUMNS, "ENTITIES", where).sql(), params);
    }

    public static PreparedQuery generateInsertQuery(@Nonnull List<String> allColumns, @Nonnull String tableName, List<Object> values, String realmId) {
        ArrayList<String> finalColumns = new ArrayList<String>(allColumns);
        ArrayList<Object> finalValues = new ArrayList<Object>(values);
        finalColumns.add("realm_id");
        finalValues.add(realmId);
        String columns = String.join((CharSequence)", ", finalColumns);
        String placeholders = finalColumns.stream().map(c -> "?").collect(Collectors.joining(", "));
        String sql = "INSERT INTO " + QueryGenerator.getFullyQualifiedTableName(tableName) + " (" + columns + ") VALUES (" + placeholders + ")";
        return new PreparedQuery(sql, finalValues);
    }

    public static PreparedQuery generateUpdateQuery(@Nonnull List<String> allColumns, @Nonnull String tableName, @Nonnull List<Object> values, @Nonnull Map<String, Object> whereClause) {
        ArrayList<Object> bindingParams = new ArrayList<Object>(values);
        QueryFragment where = QueryGenerator.generateWhereClause(new HashSet<String>(allColumns), whereClause);
        String setClause = allColumns.stream().map(c -> c + " = ?").collect(Collectors.joining(", "));
        String sql = "UPDATE " + QueryGenerator.getFullyQualifiedTableName(tableName) + " SET " + setClause + where.sql();
        bindingParams.addAll(where.parameters());
        return new PreparedQuery(sql, bindingParams);
    }

    public static PreparedQuery generateDeleteQuery(@Nonnull List<String> tableColumns, @Nonnull String tableName, @Nonnull Map<String, Object> whereClause) {
        QueryFragment where = QueryGenerator.generateWhereClause(new HashSet<String>(tableColumns), whereClause);
        return new PreparedQuery("DELETE FROM " + QueryGenerator.getFullyQualifiedTableName(tableName) + where.sql(), where.parameters());
    }

    private static PreparedQuery generateSelectQuery(@Nonnull List<String> columnNames, @Nonnull String tableName, @Nonnull String filter) {
        String sql = "SELECT " + String.join((CharSequence)", ", columnNames) + " FROM " + QueryGenerator.getFullyQualifiedTableName(tableName) + filter;
        return new PreparedQuery(sql, Collections.emptyList());
    }

    @VisibleForTesting
    static QueryFragment generateWhereClause(@Nonnull Set<String> tableColumns, @Nonnull Map<String, Object> whereClause) {
        ArrayList<CallSite> conditions = new ArrayList<CallSite>();
        ArrayList<Object> parameters = new ArrayList<Object>();
        for (Map.Entry<String, Object> entry : whereClause.entrySet()) {
            if (!tableColumns.contains(entry.getKey()) && !entry.getKey().equals("realm_id")) {
                throw new IllegalArgumentException("Invalid query column: " + entry.getKey());
            }
            conditions.add((CallSite)((Object)(entry.getKey() + " = ?")));
            parameters.add(entry.getValue());
        }
        String clause = conditions.isEmpty() ? "" : " WHERE " + String.join((CharSequence)" AND ", conditions);
        return new QueryFragment(clause, parameters);
    }

    @VisibleForTesting
    static PreparedQuery generateVersionQuery() {
        return new PreparedQuery("SELECT version_value FROM POLARIS_SCHEMA.VERSION", List.of());
    }

    @VisibleForTesting
    public static PreparedQuery generateOverlapQuery(String realmId, long catalogId, String baseLocation) {
        StorageLocation baseStorageLocation = StorageLocation.of((String)baseLocation);
        String locationWithoutScheme = baseStorageLocation.withoutScheme();
        ArrayList<String> conditions = new ArrayList<String>();
        ArrayList<Object> parameters = new ArrayList<Object>();
        String[] components = locationWithoutScheme.split("/");
        StringBuilder pathBuilder = new StringBuilder();
        for (String component : components) {
            pathBuilder.append(component).append("/");
            conditions.add("location_without_scheme = ?");
            parameters.add(pathBuilder.toString());
        }
        conditions.add("location_without_scheme LIKE ?");
        parameters.add(locationWithoutScheme + "%");
        String locationClause = String.join((CharSequence)" OR ", conditions);
        String clause = " WHERE realm_id = ? AND catalog_id = ? AND (" + locationClause + ")";
        ArrayList<Object> finalParams = new ArrayList<Object>();
        finalParams.add(realmId);
        finalParams.add(catalogId);
        finalParams.addAll(parameters);
        QueryFragment where = new QueryFragment(clause, finalParams);
        PreparedQuery query = QueryGenerator.generateSelectQuery(ModelEntity.ALL_COLUMNS, "ENTITIES", where.sql());
        return new PreparedQuery(query.sql(), where.parameters());
    }

    private static String getFullyQualifiedTableName(String tableName) {
        return "POLARIS_SCHEMA." + tableName;
    }

    record QueryFragment(String sql, List<Object> parameters) {
    }

    public record PreparedQuery(String sql, List<Object> parameters) {
    }
}

