/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.persistence.varint;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;

public final class VarInt {
    private static final int MAX_LEN = 9;
    private static final int MAX_SHIFT_LEN = 63;

    private VarInt() {
    }

    public static int varIntLen(long v) {
        Preconditions.checkArgument((v >= 0L ? 1 : 0) != 0);
        int l = 0;
        while (true) {
            ++l;
            if (v <= 127L) {
                return l;
            }
            v >>= 7;
        }
    }

    public static ByteBuffer putVarInt(ByteBuffer b, long v) {
        Preconditions.checkArgument((v >= 0L ? 1 : 0) != 0);
        while (v > 127L) {
            b.put((byte)(v | 0x80L));
            v >>= 7;
        }
        return b.put((byte)v);
    }

    public static int readVarInt(ByteBuffer b) {
        return Ints.checkedCast((long)VarInt.readVarLong(b));
    }

    public static long readVarLong(ByteBuffer b) {
        long r = 0L;
        int shift = 0;
        while (true) {
            Preconditions.checkArgument((shift < 63 ? 1 : 0) != 0, (Object)"Illegal variable length integer representation");
            long v = b.get() & 0xFF;
            r |= (v & 0x7FL) << shift;
            if ((v & 0x80L) == 0L) break;
            shift += 7;
        }
        return r;
    }

    public static void skipVarInt(ByteBuffer b) {
        int shift = 0;
        while (true) {
            Preconditions.checkArgument((shift < 63 ? 1 : 0) != 0, (Object)"Illegal variable length integer representation");
            int v = b.get() & 0xFF;
            if ((v & 0x80) == 0) break;
            shift += 7;
        }
    }
}

