/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.extension.persistence.impl.eclipselink.models;

import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import org.apache.polaris.core.entity.EntityNameLookupRecord;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;

@Entity
@Table(name="ENTITIES_ACTIVE")
public class ModelEntityActive {
    @Id
    private long catalogId;
    @Id
    private long id;
    @Id
    private long parentId;
    private String name;
    @Id
    private int typeCode;
    private int subTypeCode;

    public long getCatalogId() {
        return this.catalogId;
    }

    public long getId() {
        return this.id;
    }

    public long getParentId() {
        return this.parentId;
    }

    public String getName() {
        return this.name;
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public PolarisEntityType getType() {
        return PolarisEntityType.fromCode((int)this.typeCode);
    }

    public int getSubTypeCode() {
        return this.subTypeCode;
    }

    public PolarisEntitySubType getSubType() {
        return PolarisEntitySubType.fromCode((int)this.subTypeCode);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ModelEntityActive fromEntityActive(EntityNameLookupRecord record) {
        return ModelEntityActive.builder().catalogId(record.getCatalogId()).id(record.getId()).parentId(record.getParentId()).name(record.getName()).typeCode(record.getTypeCode()).subTypeCode(record.getSubTypeCode()).build();
    }

    public static EntityNameLookupRecord toEntityActive(ModelEntityActive model) {
        if (model == null) {
            return null;
        }
        return new EntityNameLookupRecord(model.catalogId, model.id, model.parentId, model.name, model.typeCode, model.subTypeCode);
    }

    public static final class Builder {
        private final ModelEntityActive entity = new ModelEntityActive();

        private Builder() {
        }

        public Builder catalogId(long catalogId) {
            this.entity.catalogId = catalogId;
            return this;
        }

        public Builder id(long id) {
            this.entity.id = id;
            return this;
        }

        public Builder parentId(long parentId) {
            this.entity.parentId = parentId;
            return this;
        }

        public Builder typeCode(int typeCode) {
            this.entity.typeCode = typeCode;
            return this;
        }

        public Builder name(String name) {
            this.entity.name = name;
            return this;
        }

        public Builder subTypeCode(int subTypeCode) {
            this.entity.subTypeCode = subTypeCode;
            return this;
        }

        public ModelEntityActive build() {
            return this.entity;
        }
    }
}

