/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.docs.generator;

import com.sun.source.doctree.DocCommentTree;
import io.smallrye.config.ConfigMappingInterface;
import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.apache.polaris.docs.ConfigDocs;
import org.apache.polaris.docs.generator.PropertyInfo;

public class SmallRyeConfigPropertyInfo
implements PropertyInfo {
    private final ConfigMappingInterface.Property property;
    private final String propertyName;
    private final DocCommentTree doc;
    private final ExecutableElement element;

    SmallRyeConfigPropertyInfo(ExecutableElement element, ConfigMappingInterface.Property property, String propertyName, DocCommentTree doc) {
        this.element = element;
        this.property = property;
        this.propertyName = propertyName;
        this.doc = doc;
    }

    @Override
    public Element propertyElement() {
        return this.element;
    }

    @Override
    public String propertyName() {
        return this.propertyName;
    }

    public Optional<String> prefixOverride() {
        String section;
        ConfigDocs.ConfigItem item = this.element.getAnnotation(ConfigDocs.ConfigItem.class);
        if (item != null && (section = item.section()) != null && !section.isEmpty()) {
            return Optional.of(section);
        }
        return Optional.empty();
    }

    public boolean sectionDocFromType() {
        ConfigDocs.ConfigItem item = this.element.getAnnotation(ConfigDocs.ConfigItem.class);
        return item != null && item.sectionDocFromType();
    }

    @Override
    public String propertySuffix() {
        if (this.property.isMap()) {
            ConfigDocs.ConfigPropertyName ci = this.element.getAnnotation(ConfigDocs.ConfigPropertyName.class);
            return ci == null || ci.value().isEmpty() ? "name" : ci.value();
        }
        return "";
    }

    @Override
    public String simplifiedTypeName() {
        return SmallRyeConfigPropertyInfo.simplifiedTypeName(this.property);
    }

    public boolean isSettableType() {
        return SmallRyeConfigPropertyInfo.isSettableType(this.property);
    }

    @Override
    public Optional<Class<?>> groupType() {
        ConfigMappingInterface.Property p = this.property;
        if (p.isOptional()) {
            p = p.asOptional().getNestedProperty();
        }
        if (p.isCollection()) {
            p = p.asCollection().getElement();
        }
        if (p.isMap()) {
            p = p.asMap().getValueProperty();
        }
        return p.isGroup() ? Optional.of(p.asGroup().getGroupType().getInterfaceType()) : Optional.empty();
    }

    public static boolean isSettableType(ConfigMappingInterface.Property property) {
        if (property.isOptional()) {
            ConfigMappingInterface.MayBeOptionalProperty nested = property.asOptional().getNestedProperty();
            return SmallRyeConfigPropertyInfo.isSettableType((ConfigMappingInterface.Property)nested);
        }
        if (property.isCollection()) {
            return true;
        }
        if (property.isMap()) {
            ConfigMappingInterface.MapProperty map = property.asMap();
            ConfigMappingInterface.Property value = map.getValueProperty();
            return SmallRyeConfigPropertyInfo.isSettableType(value);
        }
        if (property.isPrimitive()) {
            return true;
        }
        if (property.isLeaf()) {
            return true;
        }
        if (property.isGroup()) {
            return false;
        }
        throw new UnsupportedOperationException("Don't know how to handle " + String.valueOf(property));
    }

    public static String simplifiedTypeName(ConfigMappingInterface.Property property) {
        if (property.isOptional()) {
            ConfigMappingInterface.MayBeOptionalProperty nested = property.asOptional().getNestedProperty();
            return SmallRyeConfigPropertyInfo.simplifiedTypeName((ConfigMappingInterface.Property)nested);
        }
        if (property.isCollection()) {
            ConfigMappingInterface.CollectionProperty coll = property.asCollection();
            ConfigMappingInterface.Property element = coll.getElement();
            return "list of " + SmallRyeConfigPropertyInfo.simplifiedTypeName(element);
        }
        if (property.isMap()) {
            ConfigMappingInterface.MapProperty map = property.asMap();
            ConfigMappingInterface.Property value = map.getValueProperty();
            return SmallRyeConfigPropertyInfo.simplifiedTypeName(value);
        }
        if (property.isPrimitive()) {
            return property.asPrimitive().getPrimitiveType().getSimpleName();
        }
        if (property.isLeaf()) {
            ConfigMappingInterface.LeafProperty leaf = property.asLeaf();
            Class rawType = leaf.getValueRawType();
            if (rawType.isEnum()) {
                return Arrays.stream(rawType.getEnumConstants()).map(Enum.class::cast).map(Enum::name).collect(Collectors.joining(", "));
            }
            if (property.hasConvertWith()) {
                return "string";
            }
            if (rawType == OptionalInt.class) {
                return "int";
            }
            if (rawType == OptionalLong.class) {
                return "long";
            }
            if (rawType == OptionalDouble.class) {
                return "double";
            }
            if (rawType == Boolean.class) {
                return "boolean";
            }
            if (rawType == Byte.class) {
                return "byte";
            }
            if (rawType == Short.class) {
                return "short";
            }
            if (rawType == Integer.class) {
                return "int";
            }
            if (rawType == Long.class) {
                return "long";
            }
            if (rawType == Float.class) {
                return "float";
            }
            if (rawType == Double.class) {
                return "double";
            }
            if (rawType == Character.class) {
                return "char";
            }
            if (rawType == String.class) {
                return "string";
            }
            if (rawType == Duration.class) {
                return "duration";
            }
            if (rawType == Instant.class) {
                return "instant";
            }
            if (rawType == URI.class) {
                return "uri";
            }
            if (rawType == Path.class) {
                return "path";
            }
            return rawType.getSimpleName();
        }
        if (property.isGroup()) {
            return "";
        }
        throw new UnsupportedOperationException("Don't know how to handle " + String.valueOf(property));
    }

    @Override
    public DocCommentTree doc() {
        return this.doc;
    }

    @Override
    public String defaultValue() {
        return SmallRyeConfigPropertyInfo.defaultValue(this.property);
    }

    public static String defaultValue(ConfigMappingInterface.Property property) {
        if (property.isOptional()) {
            ConfigMappingInterface.MayBeOptionalProperty nested = property.asOptional().getNestedProperty();
            return SmallRyeConfigPropertyInfo.defaultValue((ConfigMappingInterface.Property)nested);
        }
        if (property.isPrimitive()) {
            ConfigMappingInterface.PrimitiveProperty primitive = property.asPrimitive();
            return primitive.hasDefaultValue() ? primitive.getDefaultValue() : null;
        }
        if (property.isLeaf()) {
            ConfigMappingInterface.LeafProperty leaf = property.asLeaf();
            return leaf.hasDefaultValue() ? leaf.getDefaultValue() : null;
        }
        return null;
    }
}

