/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.docs.generator;

import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappingInterface;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.AbstractElementVisitor8;
import javax.tools.StandardLocation;
import jdk.javadoc.doclet.DocletEnvironment;
import org.apache.polaris.docs.generator.SmallRyeConfigMappingInfo;

public class SmallRyeConfigs {
    private final DocletEnvironment env;
    private final ClassLoader classLoader;
    private final Map<String, SmallRyeConfigMappingInfo> configMappingInfos = new HashMap<String, SmallRyeConfigMappingInfo>();
    private final Map<String, SmallRyeConfigMappingInfo> configMappingByType = new HashMap<String, SmallRyeConfigMappingInfo>();

    public SmallRyeConfigs(DocletEnvironment env) {
        this.classLoader = env.getJavaFileManager().getClassLoader(StandardLocation.CLASS_PATH);
        this.env = env;
    }

    Collection<SmallRyeConfigMappingInfo> configMappingInfos() {
        return this.configMappingInfos.values();
    }

    static String concatWithDot(String s1, String s2) {
        boolean v2;
        StringBuilder sb = new StringBuilder();
        boolean v1 = s1 != null && !s1.isEmpty();
        boolean bl = v2 = s2 != null && !s2.isEmpty();
        if (v1) {
            sb.append(s1);
        }
        if (v1 && v2) {
            sb.append('.');
        }
        if (v2) {
            sb.append(s2);
        }
        return sb.toString();
    }

    TypeElement getTypeElement(String typeName) {
        TypeElement elem = this.env.getElementUtils().getTypeElement(typeName);
        if (elem == null) {
            elem = this.env.getElementUtils().getTypeElement(typeName.replace('$', '.'));
        }
        return Objects.requireNonNull(elem, "Could not find type '" + typeName + "'");
    }

    public SmallRyeConfigMappingInfo getConfigMappingInfo(Class<?> type) {
        String typeName = type.getName();
        SmallRyeConfigMappingInfo info = this.configMappingByType.get(typeName);
        if (info == null) {
            info = new SmallRyeConfigMappingInfo("");
            this.configMappingByType.put(typeName, info);
            this.getTypeElement(typeName).accept(this.visitor(), null);
        }
        return info;
    }

    ElementVisitor<Void, Void> visitor() {
        return new AbstractElementVisitor8<Void, Void>(){

            @Override
            public Void visitPackage(PackageElement e, Void ignore) {
                return null;
            }

            @Override
            public Void visitType(TypeElement e, Void ignore) {
                switch (e.getKind()) {
                    case CLASS: 
                    case INTERFACE: {
                        ConfigMappingInterface configMappingInterface;
                        Class<?> clazz;
                        SmallRyeConfigMappingInfo mappingInfo;
                        ConfigMapping configMapping = e.getAnnotation(ConfigMapping.class);
                        String className = e.getQualifiedName().toString();
                        if (configMapping != null) {
                            mappingInfo = SmallRyeConfigs.this.configMappingInfos.computeIfAbsent(configMapping.prefix(), SmallRyeConfigMappingInfo::new);
                            clazz = this.loadClass(className);
                            try {
                                configMappingInterface = ConfigMappingInterface.getConfigurationInterface(clazz);
                            }
                            catch (RuntimeException ex) {
                                throw new RuntimeException("Failed to process mapped " + String.valueOf(clazz), ex);
                            }
                            SmallRyeConfigs.this.configMappingByType.put(configMappingInterface.getInterfaceType().getName(), mappingInfo);
                        } else {
                            mappingInfo = SmallRyeConfigs.this.configMappingByType.get(className);
                            if (mappingInfo == null) {
                                return null;
                            }
                            clazz = this.loadClass(className);
                            try {
                                configMappingInterface = ConfigMappingInterface.getConfigurationInterface(clazz);
                            }
                            catch (RuntimeException ex) {
                                throw new RuntimeException("Failed to process implicitly added " + String.valueOf(clazz), ex);
                            }
                        }
                        mappingInfo.processType(SmallRyeConfigs.this.env, configMappingInterface, e);
                        HashSet<Class> seen = new HashSet<Class>();
                        ArrayDeque<ConfigMappingInterface> remaining = new ArrayDeque<ConfigMappingInterface>(Arrays.asList(configMappingInterface.getSuperTypes()));
                        while (!remaining.isEmpty()) {
                            ConfigMappingInterface superType = remaining.removeFirst();
                            if (!seen.add(superType.getInterfaceType())) continue;
                            remaining.addAll(Arrays.asList(superType.getSuperTypes()));
                            TypeElement superTypeElement = SmallRyeConfigs.this.getTypeElement(superType.getInterfaceType().getName());
                            mappingInfo.processType(SmallRyeConfigs.this.env, superType, superTypeElement);
                        }
                        ArrayDeque remainingClasses = new ArrayDeque();
                        if (clazz.getSuperclass() != null) {
                            remainingClasses.add(clazz.getSuperclass());
                        }
                        remainingClasses.addAll(Arrays.asList(clazz.getInterfaces()));
                        while (!remainingClasses.isEmpty()) {
                            Class c = (Class)remainingClasses.removeFirst();
                            if (!seen.add(c)) continue;
                            TypeElement superTypeElement = SmallRyeConfigs.this.getTypeElement(c.getName());
                            mappingInfo.processType(SmallRyeConfigs.this.env, configMappingInterface, superTypeElement);
                            if (c.getSuperclass() != null) {
                                remainingClasses.add(c.getSuperclass());
                            }
                            remainingClasses.addAll(Arrays.asList(c.getInterfaces()));
                        }
                        break;
                    }
                }
                return null;
            }

            private Class<?> loadClass(String className) {
                try {
                    return Class.forName(className, false, SmallRyeConfigs.this.classLoader);
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public Void visitVariable(VariableElement e, Void ignore) {
                return null;
            }

            @Override
            public Void visitExecutable(ExecutableElement e, Void ignore) {
                return null;
            }

            @Override
            public Void visitTypeParameter(TypeParameterElement e, Void ignore) {
                return null;
            }
        };
    }
}

