/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.docs.generator;

import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.tools.DiagnosticListener;
import javax.tools.DocumentationTool;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.apache.polaris.docs.generator.DocGenDoclet;
import picocli.CommandLine;

@CommandLine.Command(name="generate", mixinStandardHelpOptions=true, description={"Generate markdown documentation"})
public class ReferenceConfigDocsGenerator
implements Callable<Integer> {
    @CommandLine.Option(names={"-cp", "--classpath"}, arity="*", split=":")
    List<Path> classpath = new ArrayList<Path>();
    @CommandLine.Option(names={"-sp", "--sourcepath"}, arity="*", split=":")
    List<Path> sourcepath = new ArrayList<Path>();
    @CommandLine.Option(names={"-d", "--destination"}, arity="1", required=true)
    Path output;
    @CommandLine.Option(names={"-v", "--verbose"})
    boolean verbose;

    public ReferenceConfigDocsGenerator() {
    }

    public ReferenceConfigDocsGenerator(List<Path> sourcepath, List<Path> classpath, Path output, boolean verbose) {
        this.classpath = classpath;
        this.sourcepath = sourcepath;
        this.output = output;
        this.verbose = verbose;
    }

    @Override
    public Integer call() throws Exception {
        DocumentationTool docTool = ServiceLoader.load(DocumentationTool.class).findFirst().orElseThrow(() -> new IllegalStateException("No DocumentationTool instance present"));
        Files.createDirectories(this.output, new FileAttribute[0]);
        StandardJavaFileManager fileManager = docTool.getStandardFileManager(null, null, null);
        fileManager.setLocationFromPaths(StandardLocation.SOURCE_PATH, this.sourcepath);
        fileManager.setLocationFromPaths(StandardLocation.CLASS_PATH, this.classpath);
        fileManager.setLocationFromPaths(DocumentationTool.Location.DOCUMENTATION_OUTPUT, List.of(this.output));
        Iterable<JavaFileObject> sourceFiles = fileManager.list(StandardLocation.SOURCE_PATH, "", Set.of(JavaFileObject.Kind.SOURCE), true);
        List<String> options = List.of("--ignore-source-errors", "-Xmaxwarns", this.verbose ? "100" : "1", "-Xmaxerrs", this.verbose ? "100" : "1", "-d", this.output.toString());
        DiagnosticListener diagnostics = this.verbose ? null : diagnostic -> {};
        Writer out = this.verbose ? null : Writer.nullWriter();
        DocumentationTool.DocumentationTask docTask = docTool.getTask(out, fileManager, diagnostics, DocGenDoclet.class, options, sourceFiles);
        Boolean result = docTask.call();
        return result != false ? 0 : 1;
    }

    public static void main(String[] args) {
        ReferenceConfigDocsGenerator tool = new ReferenceConfigDocsGenerator();
        CommandLine commandLine = new CommandLine((Object)tool).setExecutionExceptionHandler((ex, cmd, parseResult) -> {
            cmd.getErr().println(cmd.getColorScheme().richStackTraceString((Throwable)ex));
            return cmd.getExitCodeExceptionMapper() != null ? cmd.getExitCodeExceptionMapper().getExitCode((Throwable)ex) : cmd.getCommandSpec().exitCodeOnExecutionException();
        });
        System.exit(commandLine.execute(args));
    }
}

