package org.apache.polaris.core.admin.model;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@ApiModel(description="Updates to apply to a Catalog Role")@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-12-29T15:11:10.844412180Z[UTC]", comments = "Generator version: 7.12.0")public class UpdateCatalogRoleRequest   {

  @NotNull
  private final Integer currentEntityVersion;
  @NotNull
  private final Map<String, String> properties;
    /**
     * The version of the object onto which this update is applied; if the object changed, the update will fail and the caller should retry after fetching the latest version.
     **/
    @ApiModelProperty(required = true, value = "The version of the object onto which this update is applied; if the object changed, the update will fail and the caller should retry after fetching the latest version.")
    @JsonProperty(value = "currentEntityVersion", required = true)
    public Integer getCurrentEntityVersion() {
        return currentEntityVersion;
    }
    
    /**
     **/
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(value = "properties", required = true)
    public Map<String, String> getProperties() {
        return properties;
    }
    
    @JsonCreator
    public UpdateCatalogRoleRequest(@JsonProperty(value = "currentEntityVersion", required = true) Integer currentEntityVersion, @JsonProperty(value = "properties", required = true) Map<String, String> properties) {
        this.currentEntityVersion = currentEntityVersion;
        this.properties = Objects.requireNonNullElse(properties, new HashMap<>());
    }



    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(Integer currentEntityVersion, Map<String, String> properties) {
        return new Builder(currentEntityVersion, properties);
    }


    public static final class Builder {
      private Integer currentEntityVersion;
      private Map<String, String> properties;
      private Builder() {
      }
      private Builder(Integer currentEntityVersion, Map<String, String> properties) {
        this.currentEntityVersion = currentEntityVersion;
        this.properties = Objects.requireNonNullElse(properties, new HashMap<>());
      }

      public Builder setCurrentEntityVersion(Integer currentEntityVersion) {
        this.currentEntityVersion = currentEntityVersion;
        return this;
      }
      public Builder setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
      }


      public UpdateCatalogRoleRequest build() {
        UpdateCatalogRoleRequest inst = new UpdateCatalogRoleRequest(currentEntityVersion, properties);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateCatalogRoleRequest updateCatalogRoleRequest = (UpdateCatalogRoleRequest) o;
    return Objects.equals(this.currentEntityVersion, updateCatalogRoleRequest.currentEntityVersion) &&
        Objects.equals(this.properties, updateCatalogRoleRequest.properties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(currentEntityVersion, properties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateCatalogRoleRequest {\n");
    
    sb.append("    currentEntityVersion: ").append(toIndentedString(currentEntityVersion)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
