package org.apache.polaris.core.admin.model;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.polaris.core.admin.model.AuthenticationParameters;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@ApiModel(description="AWS Signature Version 4 authentication")@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-12-29T15:11:10.844412180Z[UTC]", comments = "Generator version: 7.12.0")public class SigV4AuthenticationParameters extends AuthenticationParameters  {

  @NotNull
  private final String roleArn;
  private final String roleSessionName;
  private final String externalId;
  @NotNull
  private final String signingRegion;
  private final String signingName;
    /**
     * The aws IAM role arn assumed by polaris userArn when signing requests
     **/
    @ApiModelProperty(example = "arn:aws:iam::123456789001:role/role-that-has-remote-catalog-access", required = true, value = "The aws IAM role arn assumed by polaris userArn when signing requests")
    @JsonProperty(value = "roleArn", required = true)
    public String getRoleArn() {
        return roleArn;
    }
    
    /**
     * The role session name to be used by the SigV4 protocol for signing requests
     **/
    @ApiModelProperty(example = "polaris-remote-catalog-access", value = "The role session name to be used by the SigV4 protocol for signing requests")
    @JsonProperty(value = "roleSessionName")
    public String getRoleSessionName() {
        return roleSessionName;
    }
    
    /**
     * An optional external id used to establish a trust relationship with AWS in the trust policy
     **/
    @ApiModelProperty(example = "external-id-1234", value = "An optional external id used to establish a trust relationship with AWS in the trust policy")
    @JsonProperty(value = "externalId")
    public String getExternalId() {
        return externalId;
    }
    
    /**
     * Region to be used by the SigV4 protocol for signing requests
     **/
    @ApiModelProperty(example = "us-west-2", required = true, value = "Region to be used by the SigV4 protocol for signing requests")
    @JsonProperty(value = "signingRegion", required = true)
    public String getSigningRegion() {
        return signingRegion;
    }
    
    /**
     * The service name to be used by the SigV4 protocol for signing requests, the default signing name is \&quot;execute-api\&quot; is if not provided
     **/
    @ApiModelProperty(example = "glue", value = "The service name to be used by the SigV4 protocol for signing requests, the default signing name is \"execute-api\" is if not provided")
    @JsonProperty(value = "signingName")
    public String getSigningName() {
        return signingName;
    }
    
    @JsonCreator
    public SigV4AuthenticationParameters(@JsonProperty(value = "roleArn", required = true) String roleArn, @JsonProperty(value = "roleSessionName") String roleSessionName, @JsonProperty(value = "externalId") String externalId, @JsonProperty(value = "signingRegion", required = true) String signingRegion, @JsonProperty(value = "signingName") String signingName, @JsonProperty(value = "authenticationType", required = true) AuthenticationTypeEnum authenticationType) {
        super(authenticationType);
        this.roleArn = roleArn;
        this.roleSessionName = roleSessionName;
        this.externalId = externalId;
        this.signingRegion = signingRegion;
        this.signingName = signingName;
    }


    public SigV4AuthenticationParameters(String roleArn, String signingRegion, AuthenticationTypeEnum authenticationType) {
        super(authenticationType);
        this.roleArn = roleArn;
        this.roleSessionName = null;
        this.externalId = null;
        this.signingRegion = signingRegion;
        this.signingName = null;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(String roleArn, String signingRegion, AuthenticationTypeEnum authenticationType) {
        return new Builder(roleArn, signingRegion, authenticationType);
    }


    public static final class Builder {
      private String roleArn;
      private String roleSessionName;
      private String externalId;
      private String signingRegion;
      private String signingName;
      private AuthenticationTypeEnum authenticationType;
      private Builder() {
      }
      private Builder(String roleArn, String signingRegion, AuthenticationTypeEnum authenticationType) {
        this.roleArn = roleArn;
        this.signingRegion = signingRegion;
        this.authenticationType = authenticationType;
      }

      public Builder setRoleArn(String roleArn) {
        this.roleArn = roleArn;
        return this;
      }
      public Builder setRoleSessionName(String roleSessionName) {
        this.roleSessionName = roleSessionName;
        return this;
      }
      public Builder setExternalId(String externalId) {
        this.externalId = externalId;
        return this;
      }
      public Builder setSigningRegion(String signingRegion) {
        this.signingRegion = signingRegion;
        return this;
      }
      public Builder setSigningName(String signingName) {
        this.signingName = signingName;
        return this;
      }
      public Builder setAuthenticationType(AuthenticationTypeEnum authenticationType) {
        this.authenticationType = authenticationType;
        return this;
      }


      public SigV4AuthenticationParameters build() {
        SigV4AuthenticationParameters inst = new SigV4AuthenticationParameters(roleArn, roleSessionName, externalId, signingRegion, signingName, authenticationType);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SigV4AuthenticationParameters sigV4AuthenticationParameters = (SigV4AuthenticationParameters) o;
    return super.equals(o) && Objects.equals(this.roleArn, sigV4AuthenticationParameters.roleArn) &&
        Objects.equals(this.roleSessionName, sigV4AuthenticationParameters.roleSessionName) &&
        Objects.equals(this.externalId, sigV4AuthenticationParameters.externalId) &&
        Objects.equals(this.signingRegion, sigV4AuthenticationParameters.signingRegion) &&
        Objects.equals(this.signingName, sigV4AuthenticationParameters.signingName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), roleArn, super.hashCode(), roleSessionName, super.hashCode(), externalId, super.hashCode(), signingRegion, super.hashCode(), signingName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SigV4AuthenticationParameters {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    roleArn: ").append(toIndentedString(roleArn)).append("\n");
    sb.append("    roleSessionName: ").append(toIndentedString(roleSessionName)).append("\n");
    sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
    sb.append("    signingRegion: ").append(toIndentedString(signingRegion)).append("\n");
    sb.append("    signingName: ").append(toIndentedString(signingName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
