package org.apache.polaris.core.admin.model;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@ApiModel(description="A Polaris principal.")@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-12-29T15:11:10.844412180Z[UTC]", comments = "Generator version: 7.12.0")public class Principal   {

  @NotNull
 @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256)  private final String name;
  private final String clientId;
  private final Map<String, String> properties;
  private final Long createTimestamp;
  private final Long lastUpdateTimestamp;
  private final Integer entityVersion;
    /**
     **/
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(value = "name", required = true)
    public String getName() {
        return name;
    }
    
    /**
     * The output-only OAuth clientId associated with this principal if applicable
     **/
    @ApiModelProperty(value = "The output-only OAuth clientId associated with this principal if applicable")
    @JsonProperty(value = "clientId")
    public String getClientId() {
        return clientId;
    }
    
    /**
     **/
    @ApiModelProperty(value = "")
    @JsonProperty(value = "properties")
    public Map<String, String> getProperties() {
        return properties;
    }
    
    /**
     **/
    @ApiModelProperty(value = "")
    @JsonProperty(value = "createTimestamp")
    public Long getCreateTimestamp() {
        return createTimestamp;
    }
    
    /**
     **/
    @ApiModelProperty(value = "")
    @JsonProperty(value = "lastUpdateTimestamp")
    public Long getLastUpdateTimestamp() {
        return lastUpdateTimestamp;
    }
    
    /**
     * The version of the principal object used to determine if the principal metadata has changed
     **/
    @ApiModelProperty(value = "The version of the principal object used to determine if the principal metadata has changed")
    @JsonProperty(value = "entityVersion")
    public Integer getEntityVersion() {
        return entityVersion;
    }
    
    @JsonCreator
    public Principal(@JsonProperty(value = "name", required = true) String name, @JsonProperty(value = "clientId") String clientId, @JsonProperty(value = "properties") Map<String, String> properties, @JsonProperty(value = "createTimestamp") Long createTimestamp, @JsonProperty(value = "lastUpdateTimestamp") Long lastUpdateTimestamp, @JsonProperty(value = "entityVersion") Integer entityVersion) {
        this.name = name;
        this.clientId = clientId;
        this.properties = Objects.requireNonNullElse(properties, new HashMap<>());
        this.createTimestamp = createTimestamp;
        this.lastUpdateTimestamp = lastUpdateTimestamp;
        this.entityVersion = entityVersion;
    }


    public Principal(String name) {
        this.name = name;
        this.clientId = null;
        this.properties = new HashMap<>();
        this.createTimestamp = null;
        this.lastUpdateTimestamp = null;
        this.entityVersion = null;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(String name) {
        return new Builder(name);
    }


    public static final class Builder {
      private String name;
      private String clientId;
      private Map<String, String> properties;
      private Long createTimestamp;
      private Long lastUpdateTimestamp;
      private Integer entityVersion;
      private Builder() {
      }
      private Builder(String name) {
        this.name = name;
      }

      public Builder setName(String name) {
        this.name = name;
        return this;
      }
      public Builder setClientId(String clientId) {
        this.clientId = clientId;
        return this;
      }
      public Builder setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
      }
      public Builder setCreateTimestamp(Long createTimestamp) {
        this.createTimestamp = createTimestamp;
        return this;
      }
      public Builder setLastUpdateTimestamp(Long lastUpdateTimestamp) {
        this.lastUpdateTimestamp = lastUpdateTimestamp;
        return this;
      }
      public Builder setEntityVersion(Integer entityVersion) {
        this.entityVersion = entityVersion;
        return this;
      }


      public Principal build() {
        Principal inst = new Principal(name, clientId, properties, createTimestamp, lastUpdateTimestamp, entityVersion);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Principal principal = (Principal) o;
    return Objects.equals(this.name, principal.name) &&
        Objects.equals(this.clientId, principal.clientId) &&
        Objects.equals(this.properties, principal.properties) &&
        Objects.equals(this.createTimestamp, principal.createTimestamp) &&
        Objects.equals(this.lastUpdateTimestamp, principal.lastUpdateTimestamp) &&
        Objects.equals(this.entityVersion, principal.entityVersion);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, clientId, properties, createTimestamp, lastUpdateTimestamp, entityVersion);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Principal {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    createTimestamp: ").append(toIndentedString(createTimestamp)).append("\n");
    sb.append("    lastUpdateTimestamp: ").append(toIndentedString(lastUpdateTimestamp)).append("\n");
    sb.append("    entityVersion: ").append(toIndentedString(entityVersion)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
