package org.apache.polaris.core.admin.model;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.polaris.core.admin.model.AuthenticationParameters;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@ApiModel(description="OAuth authentication based on client_id/client_secret")@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-12-29T15:11:10.844412180Z[UTC]", comments = "Generator version: 7.12.0")public class OAuthClientCredentialsParameters extends AuthenticationParameters  {

  private final String tokenUri;
  private final String clientId;
  private final String clientSecret;
  private final List<String> scopes;
    /**
     * Token server URI
     **/
    @ApiModelProperty(value = "Token server URI")
    @JsonProperty(value = "tokenUri")
    public String getTokenUri() {
        return tokenUri;
    }
    
    /**
     * oauth client id
     **/
    @ApiModelProperty(value = "oauth client id")
    @JsonProperty(value = "clientId")
    public String getClientId() {
        return clientId;
    }
    
    /**
     * oauth client secret (input-only)
     **/
    @ApiModelProperty(value = "oauth client secret (input-only)")
    @JsonProperty(value = "clientSecret")
    public String getClientSecret() {
        return clientSecret;
    }
    
    /**
     * oauth scopes to specify when exchanging for a short-lived access token
     **/
    @ApiModelProperty(value = "oauth scopes to specify when exchanging for a short-lived access token")
    @JsonProperty(value = "scopes")
    public List<String> getScopes() {
        return scopes;
    }
    
    @JsonCreator
    public OAuthClientCredentialsParameters(@JsonProperty(value = "tokenUri") String tokenUri, @JsonProperty(value = "clientId") String clientId, @JsonProperty(value = "clientSecret") String clientSecret, @JsonProperty(value = "scopes") List<String> scopes, @JsonProperty(value = "authenticationType", required = true) AuthenticationTypeEnum authenticationType) {
        super(authenticationType);
        this.tokenUri = tokenUri;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.scopes = Objects.requireNonNullElse(scopes, new ArrayList<>());
    }


    public OAuthClientCredentialsParameters(AuthenticationTypeEnum authenticationType) {
        super(authenticationType);
        this.tokenUri = null;
        this.clientId = null;
        this.clientSecret = null;
        this.scopes = new ArrayList<>();
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(AuthenticationTypeEnum authenticationType) {
        return new Builder(authenticationType);
    }


    public static final class Builder {
      private String tokenUri;
      private String clientId;
      private String clientSecret;
      private List<String> scopes;
      private AuthenticationTypeEnum authenticationType;
      private Builder() {
      }
      private Builder(AuthenticationTypeEnum authenticationType) {
        this.authenticationType = authenticationType;
      }

      public Builder setTokenUri(String tokenUri) {
        this.tokenUri = tokenUri;
        return this;
      }
      public Builder setClientId(String clientId) {
        this.clientId = clientId;
        return this;
      }
      public Builder setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
      }
      public Builder setScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
      }
      public Builder setAuthenticationType(AuthenticationTypeEnum authenticationType) {
        this.authenticationType = authenticationType;
        return this;
      }


      public OAuthClientCredentialsParameters build() {
        OAuthClientCredentialsParameters inst = new OAuthClientCredentialsParameters(tokenUri, clientId, clientSecret, scopes, authenticationType);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OAuthClientCredentialsParameters oauthClientCredentialsParameters = (OAuthClientCredentialsParameters) o;
    return super.equals(o) && Objects.equals(this.tokenUri, oauthClientCredentialsParameters.tokenUri) &&
        Objects.equals(this.clientId, oauthClientCredentialsParameters.clientId) &&
        Objects.equals(this.clientSecret, oauthClientCredentialsParameters.clientSecret) &&
        Objects.equals(this.scopes, oauthClientCredentialsParameters.scopes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), tokenUri, super.hashCode(), clientId, super.hashCode(), clientSecret, super.hashCode(), scopes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OAuthClientCredentialsParameters {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    tokenUri: ").append(toIndentedString(tokenUri)).append("\n");
    sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
    sb.append("    clientSecret: ").append("*").append("\n");
    sb.append("    scopes: ").append(toIndentedString(scopes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
