package org.apache.polaris.core.admin.model;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.polaris.core.admin.model.AuthenticationParameters;
import org.apache.polaris.core.admin.model.ConnectionConfigInfo;
import org.apache.polaris.core.admin.model.ServiceIdentityInfo;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@ApiModel(description="Configuration necessary for connecting to a Hadoop Catalog")@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-12-29T15:11:10.844412180Z[UTC]", comments = "Generator version: 7.12.0")public class HadoopConnectionConfigInfo extends ConnectionConfigInfo  {

  private final String warehouse;
    /**
     * The file path to where this catalog should store tables
     **/
    @ApiModelProperty(value = "The file path to where this catalog should store tables")
    @JsonProperty(value = "warehouse")
    public String getWarehouse() {
        return warehouse;
    }
    
    @JsonCreator
    public HadoopConnectionConfigInfo(@JsonProperty(value = "warehouse") String warehouse, @JsonProperty(value = "connectionType", required = true) ConnectionTypeEnum connectionType, @JsonProperty(value = "uri") String uri, @JsonProperty(value = "authenticationParameters") AuthenticationParameters authenticationParameters, @JsonProperty(value = "serviceIdentity") ServiceIdentityInfo serviceIdentity) {
        super(connectionType, uri, authenticationParameters, serviceIdentity);
        this.warehouse = warehouse;
    }


    public HadoopConnectionConfigInfo(ConnectionTypeEnum connectionType) {
        super(connectionType);
        this.warehouse = null;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ConnectionTypeEnum connectionType) {
        return new Builder(connectionType);
    }


    public static final class Builder {
      private String warehouse;
      private ConnectionTypeEnum connectionType;
      private String uri;
      private AuthenticationParameters authenticationParameters;
      private ServiceIdentityInfo serviceIdentity;
      private Builder() {
      }
      private Builder(ConnectionTypeEnum connectionType) {
        this.connectionType = connectionType;
      }

      public Builder setWarehouse(String warehouse) {
        this.warehouse = warehouse;
        return this;
      }
      public Builder setConnectionType(ConnectionTypeEnum connectionType) {
        this.connectionType = connectionType;
        return this;
      }
      public Builder setUri(String uri) {
        this.uri = uri;
        return this;
      }
      public Builder setAuthenticationParameters(AuthenticationParameters authenticationParameters) {
        this.authenticationParameters = authenticationParameters;
        return this;
      }
      public Builder setServiceIdentity(ServiceIdentityInfo serviceIdentity) {
        this.serviceIdentity = serviceIdentity;
        return this;
      }


      public HadoopConnectionConfigInfo build() {
        HadoopConnectionConfigInfo inst = new HadoopConnectionConfigInfo(warehouse, connectionType, uri, authenticationParameters, serviceIdentity);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HadoopConnectionConfigInfo hadoopConnectionConfigInfo = (HadoopConnectionConfigInfo) o;
    return super.equals(o) && Objects.equals(this.warehouse, hadoopConnectionConfigInfo.warehouse);
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), warehouse);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HadoopConnectionConfigInfo {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    warehouse: ").append(toIndentedString(warehouse)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
