package org.apache.polaris.core.admin.model;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.polaris.core.admin.model.StorageConfigInfo;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@ApiModel(description="gcp storage configuration info")@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-12-29T15:11:10.844412180Z[UTC]", comments = "Generator version: 7.12.0")public class GcpStorageConfigInfo extends StorageConfigInfo  {

  private final String gcsServiceAccount;
    /**
     * a Google cloud storage service account
     **/
    @ApiModelProperty(value = "a Google cloud storage service account")
    @JsonProperty(value = "gcsServiceAccount")
    public String getGcsServiceAccount() {
        return gcsServiceAccount;
    }
    
    @JsonCreator
    public GcpStorageConfigInfo(@JsonProperty(value = "gcsServiceAccount") String gcsServiceAccount, @JsonProperty(value = "storageType", required = true) StorageTypeEnum storageType, @JsonProperty(value = "allowedLocations") List<String> allowedLocations) {
        super(storageType, allowedLocations);
        this.gcsServiceAccount = gcsServiceAccount;
    }


    public GcpStorageConfigInfo(StorageTypeEnum storageType) {
        super(storageType);
        this.gcsServiceAccount = null;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(StorageTypeEnum storageType) {
        return new Builder(storageType);
    }


    public static final class Builder {
      private String gcsServiceAccount;
      private StorageTypeEnum storageType;
      private List<String> allowedLocations;
      private Builder() {
      }
      private Builder(StorageTypeEnum storageType) {
        this.storageType = storageType;
      }

      public Builder setGcsServiceAccount(String gcsServiceAccount) {
        this.gcsServiceAccount = gcsServiceAccount;
        return this;
      }
      public Builder setStorageType(StorageTypeEnum storageType) {
        this.storageType = storageType;
        return this;
      }
      public Builder setAllowedLocations(List<String> allowedLocations) {
        this.allowedLocations = allowedLocations;
        return this;
      }


      public GcpStorageConfigInfo build() {
        GcpStorageConfigInfo inst = new GcpStorageConfigInfo(gcsServiceAccount, storageType, allowedLocations);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GcpStorageConfigInfo gcpStorageConfigInfo = (GcpStorageConfigInfo) o;
    return super.equals(o) && Objects.equals(this.gcsServiceAccount, gcpStorageConfigInfo.gcsServiceAccount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), gcsServiceAccount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GcpStorageConfigInfo {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    gcsServiceAccount: ").append(toIndentedString(gcsServiceAccount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
