package org.apache.polaris.core.admin.model;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.polaris.core.admin.model.Principal;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-12-29T15:11:10.844412180Z[UTC]", comments = "Generator version: 7.12.0")public class CreatePrincipalRequest   {

  @Valid
  private final Principal principal;
  private final Boolean credentialRotationRequired;
    /**
     **/
    @ApiModelProperty(value = "")
    @JsonProperty(value = "principal")
    public Principal getPrincipal() {
        return principal;
    }
    
    /**
     * If true, the initial credentials can only be used to call rotateCredentials
     **/
    @ApiModelProperty(value = "If true, the initial credentials can only be used to call rotateCredentials")
    @JsonProperty(value = "credentialRotationRequired")
    public Boolean getCredentialRotationRequired() {
        return credentialRotationRequired;
    }
    
    @JsonCreator
    public CreatePrincipalRequest(@JsonProperty(value = "principal") Principal principal, @JsonProperty(value = "credentialRotationRequired") Boolean credentialRotationRequired) {
        this.principal = principal;
        this.credentialRotationRequired = credentialRotationRequired;
    }



    public static Builder builder() {
        return new Builder();
    }


    public static final class Builder {
      private Principal principal;
      private Boolean credentialRotationRequired;
      private Builder() {
      }

      public Builder setPrincipal(Principal principal) {
        this.principal = principal;
        return this;
      }
      public Builder setCredentialRotationRequired(Boolean credentialRotationRequired) {
        this.credentialRotationRequired = credentialRotationRequired;
        return this;
      }


      public CreatePrincipalRequest build() {
        CreatePrincipalRequest inst = new CreatePrincipalRequest(principal, credentialRotationRequired);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreatePrincipalRequest createPrincipalRequest = (CreatePrincipalRequest) o;
    return Objects.equals(this.principal, createPrincipalRequest.principal) &&
        Objects.equals(this.credentialRotationRequired, createPrincipalRequest.credentialRotationRequired);
  }

  @Override
  public int hashCode() {
    return Objects.hash(principal, credentialRotationRequired);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreatePrincipalRequest {\n");
    
    sb.append("    principal: ").append(toIndentedString(principal)).append("\n");
    sb.append("    credentialRotationRequired: ").append(toIndentedString(credentialRotationRequired)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
