package org.apache.polaris.core.admin.model;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.polaris.core.admin.model.CatalogProperties;
import org.apache.polaris.core.admin.model.StorageConfigInfo;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@ApiModel(description="A catalog object. A catalog may be internal or external. External catalogs are managed entirely by an external catalog interface. Third party catalogs may be other Iceberg REST implementations or other services with their own proprietary APIs")@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-12-29T15:11:10.844412180Z[UTC]", comments = "Generator version: 7.12.0")@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.EXISTING_PROPERTY,
    property = "type",
    visible = true
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = ExternalCatalog.class, name = "EXTERNAL"),
    @JsonSubTypes.Type(value = PolarisCatalog.class, name = "INTERNAL")
})public class Catalog   {

      /**
   * the type of catalog - internal or external
   */
  public enum TypeEnum {
    INTERNAL("INTERNAL"),

        EXTERNAL("EXTERNAL");
    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }
  }

  @NotNull
  private final TypeEnum type;
  @NotNull
 @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256)  private final String name;
  @NotNull
  @Valid
  private final CatalogProperties properties;
  private final Long createTimestamp;
  private final Long lastUpdateTimestamp;
  private final Integer entityVersion;
  @NotNull
  @Valid
  private final StorageConfigInfo storageConfigInfo;
    /**
     * the type of catalog - internal or external
     **/
    @ApiModelProperty(required = true, value = "the type of catalog - internal or external")
    @JsonProperty(value = "type", required = true)
    public TypeEnum getType() {
        return type;
    }
    
    /**
     * The name of the catalog
     **/
    @ApiModelProperty(required = true, value = "The name of the catalog")
    @JsonProperty(value = "name", required = true)
    public String getName() {
        return name;
    }
    
    /**
     **/
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(value = "properties", required = true)
    public CatalogProperties getProperties() {
        return properties;
    }
    
    /**
     * The creation time represented as unix epoch timestamp in milliseconds
     **/
    @ApiModelProperty(value = "The creation time represented as unix epoch timestamp in milliseconds")
    @JsonProperty(value = "createTimestamp")
    public Long getCreateTimestamp() {
        return createTimestamp;
    }
    
    /**
     * The last update time represented as unix epoch timestamp in milliseconds
     **/
    @ApiModelProperty(value = "The last update time represented as unix epoch timestamp in milliseconds")
    @JsonProperty(value = "lastUpdateTimestamp")
    public Long getLastUpdateTimestamp() {
        return lastUpdateTimestamp;
    }
    
    /**
     * The version of the catalog object used to determine if the catalog metadata has changed
     **/
    @ApiModelProperty(value = "The version of the catalog object used to determine if the catalog metadata has changed")
    @JsonProperty(value = "entityVersion")
    public Integer getEntityVersion() {
        return entityVersion;
    }
    
    /**
     **/
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(value = "storageConfigInfo", required = true)
    public StorageConfigInfo getStorageConfigInfo() {
        return storageConfigInfo;
    }
    
    @JsonCreator
    public Catalog(@JsonProperty(value = "type", required = true) TypeEnum type, @JsonProperty(value = "name", required = true) String name, @JsonProperty(value = "properties", required = true) CatalogProperties properties, @JsonProperty(value = "createTimestamp") Long createTimestamp, @JsonProperty(value = "lastUpdateTimestamp") Long lastUpdateTimestamp, @JsonProperty(value = "entityVersion") Integer entityVersion, @JsonProperty(value = "storageConfigInfo", required = true) StorageConfigInfo storageConfigInfo) {
        this.type = Objects.requireNonNullElse(type, TypeEnum.INTERNAL);
        this.name = name;
        this.properties = properties;
        this.createTimestamp = createTimestamp;
        this.lastUpdateTimestamp = lastUpdateTimestamp;
        this.entityVersion = entityVersion;
        this.storageConfigInfo = storageConfigInfo;
    }


    public Catalog(TypeEnum type, String name, CatalogProperties properties, StorageConfigInfo storageConfigInfo) {
        this.type = Objects.requireNonNullElse(type, TypeEnum.INTERNAL);
        this.name = name;
        this.properties = properties;
        this.createTimestamp = null;
        this.lastUpdateTimestamp = null;
        this.entityVersion = null;
        this.storageConfigInfo = storageConfigInfo;
    }



    public static final class Builder {
      private TypeEnum type;
      private String name;
      private CatalogProperties properties;
      private Long createTimestamp;
      private Long lastUpdateTimestamp;
      private Integer entityVersion;
      private StorageConfigInfo storageConfigInfo;
      private Builder() {
      }
      private Builder(TypeEnum type, String name, CatalogProperties properties, StorageConfigInfo storageConfigInfo) {
        this.type = Objects.requireNonNullElse(type, TypeEnum.INTERNAL);
        this.name = name;
        this.properties = properties;
        this.storageConfigInfo = storageConfigInfo;
      }

      public Builder setType(TypeEnum type) {
        this.type = type;
        return this;
      }
      public Builder setName(String name) {
        this.name = name;
        return this;
      }
      public Builder setProperties(CatalogProperties properties) {
        this.properties = properties;
        return this;
      }
      public Builder setCreateTimestamp(Long createTimestamp) {
        this.createTimestamp = createTimestamp;
        return this;
      }
      public Builder setLastUpdateTimestamp(Long lastUpdateTimestamp) {
        this.lastUpdateTimestamp = lastUpdateTimestamp;
        return this;
      }
      public Builder setEntityVersion(Integer entityVersion) {
        this.entityVersion = entityVersion;
        return this;
      }
      public Builder setStorageConfigInfo(StorageConfigInfo storageConfigInfo) {
        this.storageConfigInfo = storageConfigInfo;
        return this;
      }


      public Catalog build() {
        Catalog inst = new Catalog(type, name, properties, createTimestamp, lastUpdateTimestamp, entityVersion, storageConfigInfo);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Catalog catalog = (Catalog) o;
    return Objects.equals(this.type, catalog.type) &&
        Objects.equals(this.name, catalog.name) &&
        Objects.equals(this.properties, catalog.properties) &&
        Objects.equals(this.createTimestamp, catalog.createTimestamp) &&
        Objects.equals(this.lastUpdateTimestamp, catalog.lastUpdateTimestamp) &&
        Objects.equals(this.entityVersion, catalog.entityVersion) &&
        Objects.equals(this.storageConfigInfo, catalog.storageConfigInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, name, properties, createTimestamp, lastUpdateTimestamp, entityVersion, storageConfigInfo);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Catalog {\n");
    
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    createTimestamp: ").append(toIndentedString(createTimestamp)).append("\n");
    sb.append("    lastUpdateTimestamp: ").append(toIndentedString(lastUpdateTimestamp)).append("\n");
    sb.append("    entityVersion: ").append(toIndentedString(entityVersion)).append("\n");
    sb.append("    storageConfigInfo: ").append(toIndentedString(storageConfigInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
