/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.apache.polaris.core.admin.model.BearerAuthenticationParameters;
import org.apache.polaris.core.admin.model.OAuthClientCredentialsParameters;
import org.apache.polaris.core.admin.model.SigV4AuthenticationParameters;

@ApiModel(description="Authentication-specific information for a connection")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="authenticationType", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=BearerAuthenticationParameters.class, name="BEARER"), @JsonSubTypes.Type(value=OAuthClientCredentialsParameters.class, name="OAUTH"), @JsonSubTypes.Type(value=SigV4AuthenticationParameters.class, name="SIGV4")})
public class AuthenticationParameters {
    @NotNull
    private final AuthenticationTypeEnum authenticationType;

    @ApiModelProperty(required=true, value="The type of authentication to use when connecting to the remote rest service")
    @JsonProperty(value="authenticationType", required=true)
    public AuthenticationTypeEnum getAuthenticationType() {
        return this.authenticationType;
    }

    @JsonCreator
    public AuthenticationParameters(@JsonProperty(value="authenticationType", required=true) AuthenticationTypeEnum authenticationType) {
        this.authenticationType = authenticationType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationParameters authenticationParameters = (AuthenticationParameters)o;
        return Objects.equals((Object)this.authenticationType, (Object)authenticationParameters.authenticationType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authenticationType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticationParameters {\n");
        sb.append("    authenticationType: ").append(this.toIndentedString((Object)this.authenticationType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AuthenticationTypeEnum {
        OAUTH("OAUTH"),
        BEARER("BEARER"),
        SIGV4("SIGV4");

        private String value;

        private AuthenticationTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static final class Builder {
        private AuthenticationTypeEnum authenticationType;

        private Builder() {
        }

        private Builder(AuthenticationTypeEnum authenticationType) {
            this.authenticationType = authenticationType;
        }

        public Builder setAuthenticationType(AuthenticationTypeEnum authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        public AuthenticationParameters build() {
            AuthenticationParameters inst = new AuthenticationParameters(this.authenticationType);
            return inst;
        }
    }
}

