package org.apache.polaris.core.admin.model;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.polaris.core.admin.model.GrantResource;
import org.apache.polaris.core.admin.model.PolicyPrivilege;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-10-06T09:01:49.457542507Z[UTC]", comments = "Generator version: 7.12.0")public class PolicyGrant extends GrantResource  {

  @NotNull
  private final List<String> namespace;
  @NotNull
  private final String policyName;
  @NotNull
  @Valid
  private final PolicyPrivilege privilege;
    /**
     **/
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(value = "namespace", required = true)
    public List<String> getNamespace() {
        return namespace;
    }
    
    /**
     **/
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(value = "policyName", required = true)
    public String getPolicyName() {
        return policyName;
    }
    
    /**
     **/
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(value = "privilege", required = true)
    public PolicyPrivilege getPrivilege() {
        return privilege;
    }
    
    @JsonCreator
    public PolicyGrant(@JsonProperty(value = "namespace", required = true) List<String> namespace, @JsonProperty(value = "policyName", required = true) String policyName, @JsonProperty(value = "privilege", required = true) PolicyPrivilege privilege, @JsonProperty(value = "type", required = true) TypeEnum type) {
        super(type);
        this.namespace = Objects.requireNonNullElse(namespace, new ArrayList<>());
        this.policyName = policyName;
        this.privilege = privilege;
    }



    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(List<String> namespace, String policyName, PolicyPrivilege privilege, TypeEnum type) {
        return new Builder(namespace, policyName, privilege, type);
    }


    public static final class Builder {
      private List<String> namespace;
      private String policyName;
      private PolicyPrivilege privilege;
      private TypeEnum type;
      private Builder() {
      }
      private Builder(List<String> namespace, String policyName, PolicyPrivilege privilege, TypeEnum type) {
        this.namespace = Objects.requireNonNullElse(namespace, new ArrayList<>());
        this.policyName = policyName;
        this.privilege = privilege;
        this.type = type;
      }

      public Builder setNamespace(List<String> namespace) {
        this.namespace = namespace;
        return this;
      }
      public Builder setPolicyName(String policyName) {
        this.policyName = policyName;
        return this;
      }
      public Builder setPrivilege(PolicyPrivilege privilege) {
        this.privilege = privilege;
        return this;
      }
      public Builder setType(TypeEnum type) {
        this.type = type;
        return this;
      }


      public PolicyGrant build() {
        PolicyGrant inst = new PolicyGrant(namespace, policyName, privilege, type);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PolicyGrant policyGrant = (PolicyGrant) o;
    return super.equals(o) && Objects.equals(this.namespace, policyGrant.namespace) &&
        Objects.equals(this.policyName, policyGrant.policyName) &&
        Objects.equals(this.privilege, policyGrant.privilege);
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), namespace, super.hashCode(), policyName, super.hashCode(), privilege);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PolicyGrant {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    namespace: ").append(toIndentedString(namespace)).append("\n");
    sb.append("    policyName: ").append(toIndentedString(policyName)).append("\n");
    sb.append("    privilege: ").append(toIndentedString(privilege)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
