package org.apache.polaris.service.catalog.api.impl;



import org.apache.polaris.service.catalog.api.IcebergRestCatalogApiService;
import org.apache.polaris.service.types.CommitTableRequest;
import org.apache.iceberg.rest.requests.CommitTransactionRequest;
import org.apache.polaris.service.types.CommitViewRequest;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.CreateViewRequest;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadCredentialsResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.polaris.service.types.NotificationRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.ReportMetricsRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;

import java.util.List;

import java.io.InputStream;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;

import org.apache.polaris.core.context.RealmContext;

/**
 * Default implementation of the IcebergRestCatalogApiService. Provides default
 * implemntations for all service methods that return 501 error codes (not implemented).
 *
 * This file is automatically generated by the OpenAPI Code Generator based on configuration in the
 * pom.xml file in the module.
 *
 * DO NOT EDIT THIS FILE BY HAND - CHANGES WILL BE AUTOMATICALLY OVERWRITTEN
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-12-29T15:11:16.406523497Z[UTC]", comments = "Generator version: 7.12.0")
public class IcebergRestCatalogApiServiceImpl implements IcebergRestCatalogApiService {
  public Response commitTransaction(String prefix,CommitTransactionRequest commitTransactionRequest,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  public Response createNamespace(String prefix,CreateNamespaceRequest createNamespaceRequest,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  public Response createTable(String prefix,String namespace,CreateTableRequest createTableRequest,String xIcebergAccessDelegation,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  public Response createView(String prefix,String namespace,CreateViewRequest createViewRequest,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  public Response dropNamespace(String prefix,String namespace,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  public Response dropTable(String prefix,String namespace,String table,Boolean purgeRequested,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  public Response dropView(String prefix,String namespace,String view,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  public Response listNamespaces(String prefix,String pageToken,Integer pageSize,String parent,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  public Response listTables(String prefix,String namespace,String pageToken,Integer pageSize,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  public Response listViews(String prefix,String namespace,String pageToken,Integer pageSize,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  public Response loadCredentials(String prefix,String namespace,String table,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  public Response loadNamespaceMetadata(String prefix,String namespace,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  public Response loadTable(String prefix,String namespace,String table,String xIcebergAccessDelegation,String ifNoneMatch,String snapshots,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  public Response loadView(String prefix,String namespace,String view,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  public Response namespaceExists(String prefix,String namespace,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  public Response registerTable(String prefix,String namespace,RegisterTableRequest registerTableRequest,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  public Response renameTable(String prefix,RenameTableRequest renameTableRequest,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  public Response renameView(String prefix,RenameTableRequest renameTableRequest,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  public Response replaceView(String prefix,String namespace,String view,CommitViewRequest commitViewRequest,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  public Response reportMetrics(String prefix,String namespace,String table,ReportMetricsRequest reportMetricsRequest,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  public Response sendNotification(String prefix,String namespace,String table,NotificationRequest notificationRequest,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  public Response tableExists(String prefix,String namespace,String table,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  public Response updateProperties(String prefix,String namespace,UpdateNamespacePropertiesRequest updateNamespacePropertiesRequest,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  public Response updateTable(String prefix,String namespace,String table,CommitTableRequest commitTableRequest,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  public Response viewExists(String prefix,String namespace,String view,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
}
