package org.apache.polaris.service.catalog.api;

import org.apache.iceberg.rest.responses.ConfigResponse;
import org.apache.iceberg.rest.responses.ErrorResponse;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.aop.MeterTag;

import java.util.Map;
import java.util.List;

import java.io.InputStream;

import jakarta.annotation.Nonnull;
import jakarta.annotation.security.RolesAllowed;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.core.Response;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.SecurityContext;

import jakarta.inject.Inject;

import org.apache.polaris.core.context.RealmContext;

import org.eclipse.microprofile.faulttolerance.Timeout;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * The ConfigurationApi API interface
 *
 * This file is automatically generated by the OpenAPI Code Generator based on configuration in the
 * build.gradle file.
 *
 */
@Path("/api/catalog/v1/config")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-12-29T15:11:16.406523497Z[UTC]", comments = "Generator version: 7.12.0")
public class IcebergRestConfigurationApi  {
  private static final Logger LOGGER = LoggerFactory.getLogger(IcebergRestConfigurationApi.class);

  private final IcebergRestConfigurationApiService service;

  @Inject
  public IcebergRestConfigurationApi(IcebergRestConfigurationApiService service) {
    this.service = service;
  }

  /**
   *  All REST clients should first call this route to get catalog configuration properties from the server to configure the catalog and its HTTP client. Configuration from the server consists of two sets of key/value pairs. - defaults -  properties that should be used as default configuration; applied before client configuration - overrides - properties that should be used to override client configuration; applied after defaults and client configuration  Catalog configuration is constructed by setting the defaults, then client- provided configuration, and finally overrides. The final property set is then used to configure the catalog.  For example, a default configuration property might set the size of the client pool, which can be replaced with a client-specific setting. An override might be used to set the warehouse location, which is stored on the server rather than in client configuration.  Common catalog configuration settings are documented at https://iceberg.apache.org/docs/latest/configuration/#catalog-properties  The catalog configuration also holds an optional &#x60;endpoints&#x60; field that contains information about the endpoints supported by the server. If a server does not send the &#x60;endpoints&#x60; field, a default set of endpoints is assumed: - GET /v1/{prefix}/namespaces - POST /v1/{prefix}/namespaces - GET /v1/{prefix}/namespaces/{namespace} - DELETE /v1/{prefix}/namespaces/{namespace} - POST /v1/{prefix}/namespaces/{namespace}/properties - GET /v1/{prefix}/namespaces/{namespace}/tables - POST /v1/{prefix}/namespaces/{namespace}/tables - GET /v1/{prefix}/namespaces/{namespace}/tables/{table} - POST /v1/{prefix}/namespaces/{namespace}/tables/{table} - DELETE /v1/{prefix}/namespaces/{namespace}/tables/{table} - POST /v1/{prefix}/namespaces/{namespace}/register - POST /v1/{prefix}/namespaces/{namespace}/tables/{table}/metrics - POST /v1/{prefix}/tables/rename - POST /v1/{prefix}/transactions/commit 
   *
   * Response type: {@code CatalogConfig}.
   * @param warehouse  Warehouse location or identifier to request from the service
   *
   * @return 200 - Server specified configuration values.
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 419 - Credentials have timed out. If possible, the client should refresh credentials and retry.
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @GET
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.ConfigurationApi.getConfig")
  @Timeout
  public Response getConfig( @QueryParam("warehouse") String warehouse,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking ConfigurationApi with params")
      .addKeyValue("operation", "getConfig")
      .addKeyValue("warehouse", warehouse)
      .log();

    Response ret =
      service.getConfig(warehouse,realmContext,securityContext);
    LOGGER.debug("Completed execution of getConfig API with status code {}", ret.getStatus());
    return ret;
  }
}
