package org.apache.polaris.service.types;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-10-06T09:01:55.320737337Z[UTC]", comments = "Generator version: 7.12.0")public class PolicyAttachmentTarget   {

      /**
   * Policy can be attached to different levels: 1. table-like: Policies specific to individual tables or views. 2. namespace: Policies applies to a namespace. 3. catalog: Policies that applies to a catalog 
   */
  public enum TypeEnum {
    CATALOG("catalog"),

        NAMESPACE("namespace"),

        TABLE_LIKE("table-like");
    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }
  }

  @NotNull
  private final TypeEnum type;
  private final List<String> path;
    /**
     * Policy can be attached to different levels: 1. table-like: Policies specific to individual tables or views. 2. namespace: Policies applies to a namespace. 3. catalog: Policies that applies to a catalog 
     **/
    @ApiModelProperty(example = "table-like", required = true, value = "Policy can be attached to different levels: 1. table-like: Policies specific to individual tables or views. 2. namespace: Policies applies to a namespace. 3. catalog: Policies that applies to a catalog ")
    @JsonProperty(value = "type", required = true)
    public TypeEnum getType() {
        return type;
    }
    
    /**
     * A list representing the hierarchical path to the target, ordered from the namespace level down to the entity.  If the target is catalog, the path should be either empty or not set. 
     **/
    @ApiModelProperty(example = "[\"NS1\",\"NS2\",\"test_table_1\"]", value = "A list representing the hierarchical path to the target, ordered from the namespace level down to the entity.  If the target is catalog, the path should be either empty or not set. ")
    @JsonProperty(value = "path")
    public List<String> getPath() {
        return path;
    }
    
    @JsonCreator
    public PolicyAttachmentTarget(@JsonProperty(value = "type", required = true) TypeEnum type, @JsonProperty(value = "path") List<String> path) {
        this.type = type;
        this.path = Objects.requireNonNullElse(path, new ArrayList<>());
    }


    public PolicyAttachmentTarget(TypeEnum type) {
        this.type = type;
        this.path = new ArrayList<>();
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(TypeEnum type) {
        return new Builder(type);
    }


    public static final class Builder {
      private TypeEnum type;
      private List<String> path;
      private Builder() {
      }
      private Builder(TypeEnum type) {
        this.type = type;
      }

      public Builder setType(TypeEnum type) {
        this.type = type;
        return this;
      }
      public Builder setPath(List<String> path) {
        this.path = path;
        return this;
      }


      public PolicyAttachmentTarget build() {
        PolicyAttachmentTarget inst = new PolicyAttachmentTarget(type, path);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PolicyAttachmentTarget policyAttachmentTarget = (PolicyAttachmentTarget) o;
    return Objects.equals(this.type, policyAttachmentTarget.type) &&
        Objects.equals(this.path, policyAttachmentTarget.path);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, path);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PolicyAttachmentTarget {\n");
    
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    path: ").append(toIndentedString(path)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
