package org.apache.polaris.service.types;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.iceberg.catalog.TableIdentifier;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-10-06T09:01:55.320737337Z[UTC]", comments = "Generator version: 7.12.0")public class ListGenericTablesResponse   {

  private final String nextPageToken;
  @Valid
  private final Set<@Valid TableIdentifier> identifiers;
    /**
     * An opaque token that allows clients to make use of pagination for list APIs (e.g. ListTables). Clients may initiate the first paginated request by sending an empty query parameter &#x60;pageToken&#x60; to the server. Servers that support pagination should identify the &#x60;pageToken&#x60; parameter and return a &#x60;next-page-token&#x60; in the response if there are more results available.  After the initial request, the value of &#x60;next-page-token&#x60; from each response must be used as the &#x60;pageToken&#x60; parameter value for the next request. The server must return &#x60;null&#x60; value for the &#x60;next-page-token&#x60; in the last response. Servers that support pagination must return all results in a single response with the value of &#x60;next-page-token&#x60; set to &#x60;null&#x60; if the query parameter &#x60;pageToken&#x60; is not set in the request. Servers that do not support pagination should ignore the &#x60;pageToken&#x60; parameter and return all results in a single response. The &#x60;next-page-token&#x60; must be omitted from the response. Clients must interpret either &#x60;null&#x60; or missing response value of &#x60;next-page-token&#x60; as the end of the listing results.
     **/
    @ApiModelProperty(value = "An opaque token that allows clients to make use of pagination for list APIs (e.g. ListTables). Clients may initiate the first paginated request by sending an empty query parameter `pageToken` to the server. Servers that support pagination should identify the `pageToken` parameter and return a `next-page-token` in the response if there are more results available.  After the initial request, the value of `next-page-token` from each response must be used as the `pageToken` parameter value for the next request. The server must return `null` value for the `next-page-token` in the last response. Servers that support pagination must return all results in a single response with the value of `next-page-token` set to `null` if the query parameter `pageToken` is not set in the request. Servers that do not support pagination should ignore the `pageToken` parameter and return all results in a single response. The `next-page-token` must be omitted from the response. Clients must interpret either `null` or missing response value of `next-page-token` as the end of the listing results.")
    @JsonProperty(value = "next-page-token")
    public String getNextPageToken() {
        return nextPageToken;
    }
    
    /**
     **/
    @ApiModelProperty(value = "")
    @JsonProperty(value = "identifiers")
    public Set<@Valid TableIdentifier> getIdentifiers() {
        return identifiers;
    }
    
    @JsonCreator
    public ListGenericTablesResponse(@JsonProperty(value = "next-page-token") String nextPageToken, @JsonProperty(value = "identifiers") Set<@Valid TableIdentifier> identifiers) {
        this.nextPageToken = nextPageToken;
        this.identifiers = Objects.requireNonNullElse(identifiers, new LinkedHashSet<>());
    }



    public static Builder builder() {
        return new Builder();
    }


    public static final class Builder {
      private String nextPageToken;
      private Set<@Valid TableIdentifier> identifiers;
      private Builder() {
      }

      public Builder setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
        return this;
      }
      public Builder setIdentifiers(Set<@Valid TableIdentifier> identifiers) {
        this.identifiers = identifiers;
        return this;
      }


      public ListGenericTablesResponse build() {
        ListGenericTablesResponse inst = new ListGenericTablesResponse(nextPageToken, identifiers);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ListGenericTablesResponse listGenericTablesResponse = (ListGenericTablesResponse) o;
    return Objects.equals(this.nextPageToken, listGenericTablesResponse.nextPageToken) &&
        Objects.equals(this.identifiers, listGenericTablesResponse.identifiers);
  }

  @Override
  public int hashCode() {
    return Objects.hash(nextPageToken, identifiers);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ListGenericTablesResponse {\n");
    
    sb.append("    nextPageToken: ").append(toIndentedString(nextPageToken)).append("\n");
    sb.append("    identifiers: ").append(toIndentedString(identifiers)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
