package org.apache.polaris.service.types;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-10-06T09:01:55.320737337Z[UTC]", comments = "Generator version: 7.12.0")public class CreatePolicyRequest   {

  @NotNull
 @Pattern(regexp="^[A-Za-z0-9\\-_]+$")  private final String name;
  @NotNull
  private final String type;
  private final String description;
  private final String content;
    /**
     * A policy name. A valid policy name should only consist of uppercase and lowercase letters (A-Z, a-z), digits (0-9), hyphens (-), underscores (_).
     **/
    @ApiModelProperty(example = "compaction", required = true, value = "A policy name. A valid policy name should only consist of uppercase and lowercase letters (A-Z, a-z), digits (0-9), hyphens (-), underscores (_).")
    @JsonProperty(value = "name", required = true)
    public String getName() {
        return name;
    }
    
    /**
     **/
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(value = "type", required = true)
    public String getType() {
        return type;
    }
    
    /**
     **/
    @ApiModelProperty(value = "")
    @JsonProperty(value = "description")
    public String getDescription() {
        return description;
    }
    
    /**
     **/
    @ApiModelProperty(value = "")
    @JsonProperty(value = "content")
    public String getContent() {
        return content;
    }
    
    @JsonCreator
    public CreatePolicyRequest(@JsonProperty(value = "name", required = true) String name, @JsonProperty(value = "type", required = true) String type, @JsonProperty(value = "description") String description, @JsonProperty(value = "content") String content) {
        this.name = name;
        this.type = type;
        this.description = description;
        this.content = content;
    }


    public CreatePolicyRequest(String name, String type) {
        this.name = name;
        this.type = type;
        this.description = null;
        this.content = null;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(String name, String type) {
        return new Builder(name, type);
    }


    public static final class Builder {
      private String name;
      private String type;
      private String description;
      private String content;
      private Builder() {
      }
      private Builder(String name, String type) {
        this.name = name;
        this.type = type;
      }

      public Builder setName(String name) {
        this.name = name;
        return this;
      }
      public Builder setType(String type) {
        this.type = type;
        return this;
      }
      public Builder setDescription(String description) {
        this.description = description;
        return this;
      }
      public Builder setContent(String content) {
        this.content = content;
        return this;
      }


      public CreatePolicyRequest build() {
        CreatePolicyRequest inst = new CreatePolicyRequest(name, type, description, content);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreatePolicyRequest createPolicyRequest = (CreatePolicyRequest) o;
    return Objects.equals(this.name, createPolicyRequest.name) &&
        Objects.equals(this.type, createPolicyRequest.type) &&
        Objects.equals(this.description, createPolicyRequest.description) &&
        Objects.equals(this.content, createPolicyRequest.content);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, type, description, content);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreatePolicyRequest {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
