/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.OozieClientException;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.local.LocalOozie;
import org.apache.oozie.test.MiniOozieTestCase;
import org.apache.oozie.test.XTestCase;

public abstract class WorkflowTestCase
extends MiniOozieTestCase {
    protected void setUp() throws Exception {
        System.setProperty("oozie.log4j.file", "oozie-log4j.properties");
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected void submitAndAssert(String workflowXml, WorkflowJob.Status terminalStatus) throws OozieClientException, IOException {
        WorkflowJob finishedWorkflowJob = new WorkflowJobBuilder().submit(workflowXml).start().waitForSucceeded().build();
        WorkflowTestCase.assertNotNull((Object)finishedWorkflowJob);
        WorkflowTestCase.assertEquals((Object)terminalStatus, (Object)finishedWorkflowJob.getStatus());
    }

    protected void validate(String workflowXml) throws IOException, OozieClientException {
        new WorkflowJobBuilder().validate(workflowXml);
    }

    protected void runWorkflowFromFile(String workflowFileName, Properties additionalWorkflowProperties) throws IOException, OozieClientException {
        FileSystem fs = this.getFileSystem();
        Path appPath = new Path(this.getFsTestCaseDir(), "app");
        fs.mkdirs(appPath);
        fs.mkdirs(new Path(appPath, "lib"));
        Reader reader = this.getResourceAsReader(workflowFileName, -1);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(new Path(appPath, "workflow.xml")));
        this.copyCharStream(reader, writer);
        ((Writer)writer).close();
        reader.close();
        Path path = this.getFsTestCaseDir();
        final OozieClient oozieClient = LocalOozie.getClient();
        Properties conf = oozieClient.createConfiguration();
        conf.setProperty("oozie.wf.application.path", new Path(appPath, "workflow.xml").toString());
        conf.setProperty("user.name", WorkflowTestCase.getTestUser());
        conf.setProperty("nameNodeBasePath", path.toString());
        conf.setProperty("base", path.toUri().getPath());
        conf.setProperty("nameNode", this.getNameNodeUri());
        conf.setProperty("jobTracker", this.getJobTrackerUri());
        for (String additionalKey : additionalWorkflowProperties.stringPropertyNames()) {
            conf.setProperty(additionalKey, additionalWorkflowProperties.getProperty(additionalKey));
        }
        final String jobId = oozieClient.submit(conf);
        WorkflowTestCase.assertNotNull((Object)jobId);
        WorkflowJob wf = oozieClient.getJobInfo(jobId);
        WorkflowTestCase.assertNotNull((Object)wf);
        WorkflowTestCase.assertEquals((Object)WorkflowJob.Status.PREP, (Object)wf.getStatus());
        oozieClient.start(jobId);
        this.waitFor(15000, new XTestCase.Predicate(){

            public boolean evaluate() throws Exception {
                WorkflowJob wf = oozieClient.getJobInfo(jobId);
                return wf.getStatus() == WorkflowJob.Status.SUCCEEDED;
            }
        });
        wf = oozieClient.getJobInfo(jobId);
        WorkflowTestCase.assertNotNull((Object)wf);
        WorkflowTestCase.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wf.getStatus());
    }

    private InputStream getResourceAsStream(String path, int maxLen) throws IOException {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        if (is == null) {
            throw new IllegalArgumentException("resource " + path + " not found");
        }
        return is;
    }

    private Reader getResourceAsReader(String path, int maxLen) throws IOException {
        return new InputStreamReader(this.getResourceAsStream(path, maxLen));
    }

    private void copyCharStream(Reader reader, Writer writer) throws IOException {
        int read;
        char[] buffer = new char[4096];
        while ((read = reader.read(buffer)) > -1) {
            writer.write(buffer, 0, read);
        }
    }

    private class WorkflowJobBuilder {
        private final FileSystem dfs;
        private final Path appPath;
        private final OozieClient oozieClient = LocalOozie.getClient();
        private String workflowJobId;
        private WorkflowJob workflowJob;
        private final Path localPath;

        private WorkflowJobBuilder() throws IOException {
            this.dfs = WorkflowTestCase.this.getFileSystem();
            this.appPath = new Path(WorkflowTestCase.this.getFsTestCaseDir(), "app");
            this.localPath = new Path(File.createTempFile(this.appPath.getName(), "workflow.xml").toString());
            this.dfs.mkdirs(this.appPath);
            this.dfs.mkdirs(new Path(this.appPath, "lib"));
        }

        private WorkflowJobBuilder submit(String workflowXml) throws IOException, OozieClientException {
            this.writeToDFS(workflowXml);
            Properties conf = this.createAndResolveConfiguration();
            this.workflowJobId = this.oozieClient.submit(conf);
            TestCase.assertNotNull((Object)this.workflowJobId);
            return this;
        }

        private WorkflowJobBuilder validate(String workflowXml) throws IOException, OozieClientException {
            String result = this.oozieClient.validateXML(workflowXml);
            TestCase.assertEquals((String)"not a valid workflow xml", (String)"Valid workflow-app", (String)result);
            return this;
        }

        private void writeToDFS(String workflowXml) throws IOException {
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this.dfs.create(this.getDFSWorkflowPath()));){
                writer.write(workflowXml);
                ((Writer)writer).flush();
            }
        }

        private Properties createAndResolveConfiguration() {
            OozieClient wc = LocalOozie.getClient();
            Properties conf = wc.createConfiguration();
            conf.setProperty("oozie.wf.application.path", this.getDFSWorkflowPath().toString());
            conf.setProperty("user.name", XTestCase.getTestUser());
            conf.setProperty("nameNodeBasePath", WorkflowTestCase.this.getFsTestCaseDir().toString());
            conf.setProperty("base", WorkflowTestCase.this.getFsTestCaseDir().toUri().getPath());
            conf.setProperty("nameNode", WorkflowTestCase.this.getNameNodeUri());
            conf.setProperty("jobTracker", WorkflowTestCase.this.getJobTrackerUri());
            return conf;
        }

        private void writeToLocalFile(String workflowXml) throws IOException {
            try (FileWriter writer = new FileWriter(this.localPath.toString());){
                writer.write(workflowXml);
                ((Writer)writer).flush();
            }
        }

        private Path getDFSWorkflowPath() {
            return new Path(this.appPath, "workflow.xml");
        }

        private WorkflowJobBuilder start() throws OozieClientException {
            this.workflowJob = this.oozieClient.getJobInfo(this.workflowJobId);
            TestCase.assertNotNull((Object)this.workflowJob);
            TestCase.assertEquals((Object)WorkflowJob.Status.PREP, (Object)this.workflowJob.getStatus());
            this.oozieClient.start(this.workflowJobId);
            this.workflowJob = this.oozieClient.getJobInfo(this.workflowJobId);
            TestCase.assertEquals((Object)WorkflowJob.Status.RUNNING, (Object)this.workflowJob.getStatus());
            return this;
        }

        private WorkflowJobBuilder waitForSucceeded() throws OozieClientException {
            WorkflowTestCase.this.waitFor(15000, new XTestCase.Predicate(){

                public boolean evaluate() throws Exception {
                    WorkflowJob wf = WorkflowJobBuilder.this.oozieClient.getJobInfo(WorkflowJobBuilder.this.workflowJobId);
                    return wf.getStatus() == WorkflowJob.Status.SUCCEEDED;
                }
            });
            this.workflowJob = this.oozieClient.getJobInfo(this.workflowJobId);
            return this;
        }

        private WorkflowJob build() {
            return this.workflowJob;
        }
    }
}

