/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.test;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.MiniOozieTestCase;
import org.apache.oozie.util.XLog;

public class TestParallelJPAOperationRetries
extends MiniOozieTestCase {
    private static final XLog LOG = XLog.getLog(TestParallelJPAOperationRetries.class);
    private static final String ORIGINAL_LOG4J_FILE = System.getProperty("oozie.log4j.file");
    private volatile Exception executorException;

    protected void setUp() throws Exception {
        this.executorException = null;
        System.setProperty("oozie.log4j.file", "oozie-log4j.properties");
        System.setProperty("oozie.sql.use.failing.driver", Boolean.TRUE.toString());
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (ORIGINAL_LOG4J_FILE != null) {
            System.setProperty("oozie.log4j.file", ORIGINAL_LOG4J_FILE);
        }
    }

    public void testParallelJPAOperationsOnWorkflowBeansRetryAndSucceed() throws Exception {
        ExecutorService taskExecutor = Executors.newFixedThreadPool(4);
        int totalTaskCount = 10;
        final CountDownLatch countDownLatch = new CountDownLatch(10);
        int ixTask = 1;
        while (ixTask <= 10) {
            final int taskCount = ixTask++;
            taskExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        LOG.debug("Task #{0} started.", new Object[]{taskCount});
                        TestParallelJPAOperationRetries.this.getResultListAndExecuteUpdateOnWorkflowBeans();
                        LOG.debug("Task #{0} finished.", new Object[]{taskCount});
                    }
                    catch (SQLException e) {
                        TestParallelJPAOperationRetries.this.executorException = e;
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }
            });
        }
        countDownLatch.await();
        if (this.executorException != null) {
            TestParallelJPAOperationRetries.fail((String)String.format("Should not get an SQLException while executing SQL operations. [e.message=%s]", this.executorException.getMessage()));
        }
        taskExecutor.shutdown();
        try {
            taskExecutor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            TestParallelJPAOperationRetries.fail((String)"Should not get an interrupt while shutting down ExecutorService.");
        }
    }

    private void getResultListAndExecuteUpdateOnWorkflowBeans() throws SQLException {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        int checkAgeSecs = 86400;
        Timestamp ts = new Timestamp(System.currentTimeMillis() - 86400000L);
        EntityManager em = jpaService.getEntityManager();
        TypedQuery q = em.createNamedQuery("GET_RUNNING_ACTIONS", WorkflowActionBean.class);
        q.setParameter("lastCheckTime", (Object)ts);
        List actions = q.getResultList();
        TestParallelJPAOperationRetries.assertEquals((String)"no WorkflowActionBeans should be present", (int)0, (int)actions.size());
        if (!em.getTransaction().isActive()) {
            em.getTransaction().begin();
        }
        int rowsAffected = em.createNamedQuery("UPDATE_ACTION_FOR_LAST_CHECKED_TIME").setParameter("lastCheckTime", (Object)0L).setParameter("id", (Object)"666").executeUpdate();
        if (em.getTransaction().isActive()) {
            em.getTransaction().commit();
        }
        TestParallelJPAOperationRetries.assertEquals((String)"no rows should be affected when updating WorkflowActionBeans", (int)0, (int)rowsAffected);
    }
}

