/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow.diff;

import java.util.Objects;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedFlowCoordinates;
import org.apache.nifi.registry.flow.diff.DifferenceDescriptor;
import org.apache.nifi.registry.flow.diff.DifferenceType;

public class StaticDifferenceDescriptor
implements DifferenceDescriptor {
    @Override
    public String describeDifference(DifferenceType type, String flowAName, String flowBName, VersionedComponent componentA, VersionedComponent componentB, String fieldName, Object valueA, Object valueB) {
        return switch (type) {
            case DifferenceType.COMPONENT_ADDED -> String.format("%s with ID %s exists in %s but not in %s", componentB.getComponentType().getTypeName(), this.getId(componentB), flowBName, flowAName);
            case DifferenceType.COMPONENT_REMOVED -> String.format("%s with ID %s exists in %s but not in %s", componentA.getComponentType().getTypeName(), this.getId(componentA), flowAName, flowBName);
            case DifferenceType.PROPERTY_ADDED -> String.format("Property '%s' exists for %s with ID %s in %s but not in %s", fieldName, componentB.getComponentType().getTypeName(), this.getId(componentB), flowBName, flowAName);
            case DifferenceType.PROPERTY_REMOVED -> String.format("Property '%s' exists for %s with ID %s in %s but not in %s", fieldName, componentA.getComponentType().getTypeName(), this.getId(componentA), flowAName, flowBName);
            case DifferenceType.PROPERTY_CHANGED -> String.format("Property '%s' for %s with ID %s is different", fieldName, componentA.getComponentType().getTypeName(), this.getId(componentA));
            case DifferenceType.PROPERTY_SENSITIVITY_CHANGED -> String.format("Property '%s' for %s with ID %s has a different sensitive status", fieldName, componentA.getComponentType().getTypeName(), componentA.getIdentifier());
            case DifferenceType.PROPERTY_PARAMETERIZED -> String.format("Property '%s' is a parameter reference in %s but not in %s", fieldName, flowAName, flowBName);
            case DifferenceType.PROPERTY_PARAMETERIZATION_REMOVED -> String.format("Property '%s' is a parameter reference in %s but not in %s", fieldName, flowBName, flowAName);
            case DifferenceType.SCHEDULED_STATE_CHANGED -> String.format("%s %s has a Scheduled State of %s in %s but %s in %s", componentA.getComponentType(), this.getId(componentA), valueA, flowAName, valueB, flowBName);
            case DifferenceType.VARIABLE_ADDED -> String.format("Variable '%s' exists for Process Group with ID %s in %s but not in %s", fieldName, this.getId(componentB), flowBName, flowAName);
            case DifferenceType.VARIABLE_REMOVED -> String.format("Variable '%s' exists for Process Group with ID %s in %s but not in %s", fieldName, this.getId(componentA), flowAName, flowBName);
            case DifferenceType.VERSIONED_FLOW_COORDINATES_CHANGED -> {
                if (valueA instanceof VersionedFlowCoordinates && valueB instanceof VersionedFlowCoordinates) {
                    VersionedFlowCoordinates coordinatesA = (VersionedFlowCoordinates)valueA;
                    VersionedFlowCoordinates coordinatesB = (VersionedFlowCoordinates)valueB;
                    if (Objects.equals(coordinatesA.getRegistryUrl(), coordinatesB.getRegistryUrl()) && Objects.equals(coordinatesA.getBucketId(), coordinatesB.getBucketId()) && Objects.equals(coordinatesA.getFlowId(), coordinatesB.getFlowId()) && coordinatesA.getVersion() != coordinatesB.getVersion()) {
                        yield String.format("Flow Version is %s in %s but %s in %s", coordinatesA.getVersion(), flowAName, coordinatesB.getVersion(), flowBName);
                    }
                }
                yield String.format("%s for %s with ID %s; flow '%s' has value %s; flow '%s' has value %s", type.getDescription(), componentA.getComponentType().getTypeName(), this.getId(componentA), flowAName, valueA, flowBName, valueB);
            }
            default -> String.format("%s for %s with ID %s; flow '%s' has value %s; flow '%s' has value %s", type.getDescription(), componentA.getComponentType().getTypeName(), this.getId(componentA), flowAName, valueA, flowBName, valueB);
        };
    }

    private String getId(VersionedComponent component) {
        if (component == null) {
            return null;
        }
        if (component.getInstanceIdentifier() == null) {
            return component.getIdentifier();
        }
        return component.getInstanceIdentifier();
    }
}

