/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.extension.repo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Comparator;
import java.util.Objects;
import org.apache.nifi.registry.link.LinkableEntity;

@ApiModel
@XmlRootElement
public class ExtensionRepoVersionSummary
extends LinkableEntity
implements Comparable<ExtensionRepoVersionSummary> {
    private String bucketName;
    private String groupId;
    private String artifactId;
    private String version;
    private String author;
    private Long timestamp;

    @ApiModelProperty(value="The bucket name")
    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    @ApiModelProperty(value="The group id")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @ApiModelProperty(value="The artifact id")
    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    @ApiModelProperty(value="The version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @ApiModelProperty(value="The identity of the user that created this version")
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @ApiModelProperty(value="The timestamp of when this version was created")
    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public int compareTo(ExtensionRepoVersionSummary o) {
        return Comparator.comparing(ExtensionRepoVersionSummary::getVersion).thenComparing(ExtensionRepoVersionSummary::getArtifactId).thenComparing(ExtensionRepoVersionSummary::getGroupId).thenComparing(ExtensionRepoVersionSummary::getBucketName).compare(this, o);
    }

    public int hashCode() {
        return Objects.hash(this.bucketName, this.groupId, this.artifactId, this.version, this.author, this.timestamp);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtensionRepoVersionSummary other = (ExtensionRepoVersionSummary)obj;
        return Objects.equals(this.getBucketName(), other.getBucketName()) && Objects.equals(this.getGroupId(), other.getGroupId()) && Objects.equals(this.getArtifactId(), other.getArtifactId()) && Objects.equals(this.getVersion(), other.getVersion()) && Objects.equals(this.getAuthor(), other.getAuthor()) && Objects.equals(this.getVersion(), other.getVersion());
    }
}

