/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.services.zendesk;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.common.zendesk.ZendeskAuthenticationContext;
import org.apache.nifi.common.zendesk.ZendeskAuthenticationType;
import org.apache.nifi.common.zendesk.ZendeskClient;
import org.apache.nifi.common.zendesk.ZendeskProperties;
import org.apache.nifi.common.zendesk.util.ZendeskRecordPathUtils;
import org.apache.nifi.common.zendesk.util.ZendeskUtils;
import org.apache.nifi.common.zendesk.validation.JsonPointerPropertyNameValidator;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.record.sink.RecordSinkService;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSet;
import org.apache.nifi.web.client.api.HttpResponseEntity;
import org.apache.nifi.web.client.api.HttpResponseStatus;
import org.apache.nifi.web.client.api.HttpUriBuilder;
import org.apache.nifi.web.client.provider.api.WebClientServiceProvider;

@Tags(value={"zendesk", "record", "sink"})
@CapabilityDescription(value="Create Zendesk tickets using the Zendesk API.The service requires a Zendesk account with configured access.")
public class ZendeskRecordSink
extends AbstractControllerService
implements RecordSinkService {
    private final ObjectMapper mapper = new ObjectMapper();
    private Map<String, String> dynamicProperties;
    private Cache<String, ObjectNode> recordCache;
    private ZendeskClient zendeskClient;
    private String commentBody;
    private String subject;
    private String priority;
    private String type;
    static final PropertyDescriptor CACHE_SIZE = new PropertyDescriptor.Builder().name("cache-size").displayName("Cache Size").description("Specifies how many Zendesk ticket should be cached.").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).defaultValue("1000").required(true).build();
    static final PropertyDescriptor CACHE_EXPIRATION = new PropertyDescriptor.Builder().name("cache-expiration").displayName("Cache Expiration").description("Specifies how long a Zendesk ticket that is cached should remain in the cache.").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("1 hour").required(true).build();
    private static final List<PropertyDescriptor> PROPERTIES = Collections.unmodifiableList(Arrays.asList(ZendeskProperties.WEB_CLIENT_SERVICE_PROVIDER, ZendeskProperties.ZENDESK_SUBDOMAIN, ZendeskProperties.ZENDESK_USER, ZendeskProperties.ZENDESK_AUTHENTICATION_TYPE, ZendeskProperties.ZENDESK_AUTHENTICATION_CREDENTIAL, ZendeskProperties.ZENDESK_TICKET_COMMENT_BODY, ZendeskProperties.ZENDESK_TICKET_SUBJECT, ZendeskProperties.ZENDESK_TICKET_PRIORITY, ZendeskProperties.ZENDESK_TICKET_TYPE, CACHE_SIZE, CACHE_EXPIRATION));

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).addValidator((Validator)new JsonPointerPropertyNameValidator()).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dynamic(true).build();
    }

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    public WriteResult sendData(RecordSet recordSet, Map<String, String> attributes, boolean sendZeroResults) throws IOException {
        Record record;
        ArrayList<ObjectNode> zendeskTickets = new ArrayList<ObjectNode>();
        while ((record = recordSet.next()) != null) {
            ObjectNode baseTicketNode = this.mapper.createObjectNode();
            ZendeskRecordPathUtils.addField((String)"/comment/body", (String)this.commentBody, (ObjectNode)baseTicketNode, (Record)record);
            ZendeskRecordPathUtils.addField((String)"/subject", (String)this.subject, (ObjectNode)baseTicketNode, (Record)record);
            ZendeskRecordPathUtils.addField((String)"/priority", (String)this.priority, (ObjectNode)baseTicketNode, (Record)record);
            ZendeskRecordPathUtils.addField((String)"/type", (String)this.type, (ObjectNode)baseTicketNode, (Record)record);
            for (Map.Entry<String, String> dynamicProperty : this.dynamicProperties.entrySet()) {
                ZendeskRecordPathUtils.addDynamicField((String)dynamicProperty.getKey(), (String)dynamicProperty.getValue(), (ObjectNode)baseTicketNode, (Record)record);
            }
            ObjectNode ticketNode = (ObjectNode)this.recordCache.getIfPresent((Object)baseTicketNode.toString());
            if (ticketNode != null) continue;
            this.recordCache.put((Object)baseTicketNode.toString(), (Object)baseTicketNode);
            zendeskTickets.add(baseTicketNode);
        }
        if (!zendeskTickets.isEmpty()) {
            try {
                InputStream inputStream = ZendeskUtils.createRequestObject(zendeskTickets);
                URI uri = this.createUri(zendeskTickets.size());
                HttpResponseEntity response = this.zendeskClient.performPostRequest(uri, inputStream);
                if (response.statusCode() != HttpResponseStatus.CREATED.getCode() && response.statusCode() != HttpResponseStatus.OK.getCode()) {
                    this.getLogger().error("Failed to create zendesk ticket, HTTP status={}, response={}", new Object[]{response.statusCode(), ZendeskUtils.getResponseBody((HttpResponseEntity)response)});
                }
            }
            catch (IOException e) {
                throw new IOException("Failed to post request to Zendesk", e);
            }
        }
        return WriteResult.of((int)zendeskTickets.size(), Collections.emptyMap());
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.dynamicProperties = ZendeskUtils.getDynamicProperties((PropertyContext)context, (Map)context.getProperties(), Collections.emptyMap());
        this.commentBody = context.getProperty(ZendeskProperties.ZENDESK_TICKET_COMMENT_BODY).evaluateAttributeExpressions().getValue();
        this.subject = context.getProperty(ZendeskProperties.ZENDESK_TICKET_SUBJECT).evaluateAttributeExpressions().getValue();
        this.priority = context.getProperty(ZendeskProperties.ZENDESK_TICKET_PRIORITY).evaluateAttributeExpressions().getValue();
        this.type = context.getProperty(ZendeskProperties.ZENDESK_TICKET_TYPE).evaluateAttributeExpressions().getValue();
        String subdomain = context.getProperty(ZendeskProperties.ZENDESK_SUBDOMAIN).evaluateAttributeExpressions().getValue();
        String user = context.getProperty(ZendeskProperties.ZENDESK_USER).evaluateAttributeExpressions().getValue();
        ZendeskAuthenticationType authenticationType = ZendeskAuthenticationType.forName((String)context.getProperty(ZendeskProperties.ZENDESK_AUTHENTICATION_TYPE).getValue());
        String authenticationCredentials = context.getProperty(ZendeskProperties.ZENDESK_AUTHENTICATION_CREDENTIAL).evaluateAttributeExpressions().getValue();
        ZendeskAuthenticationContext authenticationContext = new ZendeskAuthenticationContext(subdomain, user, authenticationType, authenticationCredentials);
        WebClientServiceProvider webClientServiceProvider = (WebClientServiceProvider)context.getProperty(ZendeskProperties.WEB_CLIENT_SERVICE_PROVIDER).asControllerService(WebClientServiceProvider.class);
        this.zendeskClient = new ZendeskClient(webClientServiceProvider, authenticationContext);
        int cacheSize = context.getProperty(CACHE_SIZE).asInteger();
        long cacheExpiration = context.getProperty(CACHE_EXPIRATION).asTimePeriod(TimeUnit.NANOSECONDS);
        this.recordCache = Caffeine.newBuilder().maximumSize((long)cacheSize).expireAfterWrite(Duration.ofNanos(cacheExpiration)).build();
    }

    @OnDisabled
    public void onDisabled() {
        this.recordCache.invalidateAll();
    }

    private URI createUri(int numberOfTickets) {
        String resource = numberOfTickets > 1 ? "/api/v2/tickets/create_many" : "/api/v2/tickets";
        return this.uriBuilder(resource).build();
    }

    HttpUriBuilder uriBuilder(String resourcePath) {
        return this.zendeskClient.uriBuilder(resourcePath);
    }
}

