/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.zendesk;

import java.util.stream.Stream;
import org.apache.nifi.components.DescribedValue;

public enum ZendeskExportMethod implements DescribedValue
{
    CURSOR("cursor", "Cursor Based", "%s/cursor.json", "start_time", "cursor", "after_cursor", "In cursor-based incremental exports, each page of results includes an \"after\" cursor pointer to use as the starting cursor for the next page of results."),
    TIME("time", "Time Based", "%s.json", "start_time", "start_time", "end_time", "In time-based incremental exports, each page of results includes an end time to use as the start time for the next page of results.");

    private final String value;
    private final String displayName;
    private final String exportApiPathTemplate;
    private final String initialCursorQueryParameterName;
    private final String cursorQueryParameterName;
    private final String cursorJsonFieldName;
    private final String description;

    private ZendeskExportMethod(String value, String displayName, String exportApiPathTemplate, String initialCursorQueryParameterName, String cursorQueryParameterName, String cursorJsonFieldName, String description) {
        this.value = value;
        this.displayName = displayName;
        this.description = description;
        this.exportApiPathTemplate = exportApiPathTemplate;
        this.initialCursorQueryParameterName = initialCursorQueryParameterName;
        this.cursorQueryParameterName = cursorQueryParameterName;
        this.cursorJsonFieldName = cursorJsonFieldName;
    }

    public static ZendeskExportMethod forName(String methodName) {
        return Stream.of(ZendeskExportMethod.values()).filter(m -> m.getValue().equalsIgnoreCase(methodName)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid Zendesk incremental export method: " + methodName));
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExportApiPathTemplate() {
        return this.exportApiPathTemplate;
    }

    public String getInitialCursorQueryParameterName() {
        return this.initialCursorQueryParameterName;
    }

    public String getCursorQueryParameterName() {
        return this.cursorQueryParameterName;
    }

    public String getCursorJsonFieldName() {
        return this.cursorJsonFieldName;
    }
}

