/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.zendesk;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.processors.zendesk.ZendeskExportMethod;

public enum ZendeskResource implements DescribedValue
{
    TICKETS("/api/v2/incremental/tickets", "Tickets", "tickets", Collections.unmodifiableList(Arrays.asList(ZendeskExportMethod.TIME, ZendeskExportMethod.CURSOR)), "Tickets are the means through which end users (customers) communicate with agents in Zendesk Support."),
    TICKET_EVENTS("/api/v2/incremental/ticket_events", "Ticket Events", "ticket_events", Collections.unmodifiableList(Arrays.asList(ZendeskExportMethod.TIME)), "Stream of changes that occurred on tickets. Each event is tied to an update on a ticket and contains all the fields that were updated in that change."),
    TICKET_METRIC_EVENTS("/api/v2/incremental/ticket_metric_events", "Ticket Metric Events", "ticket_metric_events", Collections.unmodifiableList(Arrays.asList(ZendeskExportMethod.TIME)), "Ticket metric events API can be used to track reply times, agent work times, and requester wait times."),
    USERS("/api/v2/incremental/users", "Users", "users", Collections.unmodifiableList(Arrays.asList(ZendeskExportMethod.TIME, ZendeskExportMethod.CURSOR)), "Zendesk Support has three types of users: end users (customers), agents, and administrators."),
    ORGANIZATIONS("/api/v2/incremental/organizations", "Organizations", "organizations", Collections.unmodifiableList(Arrays.asList(ZendeskExportMethod.TIME)), "Just as agents can be segmented into groups in Zendesk Support, customers (end-users) can be segmented into organizations."),
    ARTICLES("/api/v2/help_center/incremental/articles", "Articles", "articles", Collections.unmodifiableList(Arrays.asList(ZendeskExportMethod.TIME)), "Articles are content items such as help topics or tech notes contained in sections."),
    NPS_RESPONSES("/api/v2/nps/incremental/responses", "NPS - Responses", "responses", Collections.unmodifiableList(Arrays.asList(ZendeskExportMethod.TIME)), "When a recipient responds to an NPS survey, their rating, comment, and last survey date are captured."),
    NPS_RECIPIENTS("/api/v2/nps/incremental/recipients", "NPS - Recipients", "recipients", Collections.unmodifiableList(Arrays.asList(ZendeskExportMethod.TIME)), "Every NPS survey is delivered to one or multiple recipients. For most businesses that use Zendesk Support, the recipients are customers. Agents and admins will never receive surveys.");

    private final String value;
    private final String displayName;
    private final String responseFieldName;
    private final List<ZendeskExportMethod> supportedExportMethods;
    private final String description;

    private ZendeskResource(String value, String displayName, String responseFieldName, List<ZendeskExportMethod> supportedExportMethods, String description) {
        this.value = value;
        this.displayName = displayName;
        this.responseFieldName = responseFieldName;
        this.supportedExportMethods = supportedExportMethods;
        this.description = description;
    }

    public static ZendeskResource forName(String resourceName) {
        return Stream.of(ZendeskResource.values()).filter(r -> r.getValue().equalsIgnoreCase(resourceName)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid Zendesk resource: " + resourceName));
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getResponseFieldName() {
        return this.responseFieldName;
    }

    public List<ZendeskExportMethod> getSupportedExportMethods() {
        return this.supportedExportMethods;
    }

    public boolean supportsExportMethod(ZendeskExportMethod exportMethod) {
        return this.supportedExportMethods.contains((Object)exportMethod);
    }

    public String apiPath(ZendeskExportMethod exportMethod) {
        return String.format(exportMethod.getExportApiPathTemplate(), this.value);
    }
}

