/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.common.zendesk.util;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.common.zendesk.util.ZendeskRecordPathUtils;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.web.client.api.HttpResponseEntity;

public final class ZendeskUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private ZendeskUtils() {
    }

    public static String getResponseBody(HttpResponseEntity response) {
        String string;
        block8: {
            InputStream responseBodyStream = response.body();
            try {
                string = IOUtils.toString((InputStream)responseBodyStream, (Charset)StandardCharsets.UTF_8);
                if (responseBodyStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (responseBodyStream != null) {
                        try {
                            responseBodyStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Reading response body has failed", e);
                }
            }
            responseBodyStream.close();
        }
        return string;
    }

    public static Map<String, String> getDynamicProperties(PropertyContext context, Map<PropertyDescriptor, String> properties, Map<String, String> attributes) {
        return properties.entrySet().stream().filter(e -> ((PropertyDescriptor)e.getKey()).isDynamic() && StringUtils.isNotBlank((CharSequence)((CharSequence)e.getValue())) && StringUtils.isNotBlank((CharSequence)context.getProperty((PropertyDescriptor)e.getKey()).evaluateAttributeExpressions(attributes).getValue())).collect(Collectors.toMap(e -> ((PropertyDescriptor)e.getKey()).getName(), e -> context.getProperty((PropertyDescriptor)e.getKey()).evaluateAttributeExpressions(attributes).getValue()));
    }

    public static InputStream createRequestObject(List<ObjectNode> zendeskTickets) throws JsonProcessingException {
        ObjectNode ticketNode = OBJECT_MAPPER.createObjectNode();
        if (zendeskTickets.size() > 1) {
            ArrayNode arrayNode = OBJECT_MAPPER.createArrayNode();
            for (ObjectNode ticket : zendeskTickets) {
                arrayNode.add((JsonNode)ticket);
            }
            ZendeskRecordPathUtils.addNewNodeAtPath(ticketNode, JsonPointer.compile((String)"/tickets"), (JsonNode)arrayNode);
        } else {
            ZendeskRecordPathUtils.addNewNodeAtPath(ticketNode, JsonPointer.compile((String)"/ticket"), (JsonNode)zendeskTickets.get(0));
        }
        return new ByteArrayInputStream(OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)ticketNode).getBytes());
    }
}

