/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.websocket;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.TriggerSerially;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.websocket.AbstractWebSocketGatewayProcessor;
import org.apache.nifi.websocket.WebSocketClientService;
import org.apache.nifi.websocket.WebSocketService;
import org.apache.nifi.websocket.WebSocketSessionInfo;

@Tags(value={"subscribe", "WebSocket", "consume", "listen"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_ALLOWED)
@TriggerSerially
@CapabilityDescription(value="Acts as a WebSocket client endpoint to interact with a remote WebSocket server. FlowFiles are transferred to downstream relationships according to received message types as WebSocket client configured with this processor receives messages from remote WebSocket server. If a new flowfile is passed to the processor, the previous sessions will be closed and any data being sent will be aborted.")
@WritesAttributes(value={@WritesAttribute(attribute="websocket.controller.service.id", description="WebSocket Controller Service id."), @WritesAttribute(attribute="websocket.session.id", description="Established WebSocket session id."), @WritesAttribute(attribute="websocket.endpoint.id", description="WebSocket endpoint id."), @WritesAttribute(attribute="websocket.local.address", description="WebSocket client address."), @WritesAttribute(attribute="websocket.remote.address", description="WebSocket server address."), @WritesAttribute(attribute="websocket.message.type", description="TEXT or BINARY.")})
public class ConnectWebSocket
extends AbstractWebSocketGatewayProcessor {
    public static final PropertyDescriptor PROP_WEBSOCKET_CLIENT_SERVICE = new PropertyDescriptor.Builder().name("websocket-client-controller-service").displayName("WebSocket Client ControllerService").description("A WebSocket CLIENT Controller Service which can connect to a WebSocket server.").required(true).identifiesControllerService(WebSocketClientService.class).build();
    public static final PropertyDescriptor PROP_WEBSOCKET_CLIENT_ID = new PropertyDescriptor.Builder().name("websocket-client-id").displayName("WebSocket Client Id").description("The client ID to identify WebSocket session. It should be unique within the WebSocket Client Controller Service. Otherwise, it throws WebSocketConfigurationException when it gets started.").required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    private static final List<PropertyDescriptor> descriptors;
    private static final Set<Relationship> relationships;

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return descriptors;
    }

    @Override
    protected WebSocketService getWebSocketService(ProcessContext context) {
        return (WebSocketService)context.getProperty(PROP_WEBSOCKET_CLIENT_SERVICE).asControllerService(WebSocketService.class);
    }

    @Override
    protected String getEndpointId(ProcessContext context) {
        return context.getProperty(PROP_WEBSOCKET_CLIENT_ID).getValue();
    }

    @Override
    protected String getTransitUri(WebSocketSessionInfo sessionInfo) {
        return ((WebSocketClientService)this.webSocketService).getTargetUri();
    }

    static {
        ArrayList<PropertyDescriptor> innerDescriptorsList = new ArrayList<PropertyDescriptor>();
        innerDescriptorsList.add(PROP_WEBSOCKET_CLIENT_SERVICE);
        innerDescriptorsList.add(PROP_WEBSOCKET_CLIENT_ID);
        descriptors = Collections.unmodifiableList(innerDescriptorsList);
        Set<Relationship> innerRelationshipsSet = ConnectWebSocket.getAbstractRelationships();
        relationships = Collections.unmodifiableSet(innerRelationshipsSet);
    }
}

