/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.util;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.UriBuilderException;
import java.util.List;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.nifi.web.util.ObjectMapperResolver;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebUtils {
    private static final Logger logger = LoggerFactory.getLogger(WebUtils.class);
    public static final String PROXY_SCHEME_HTTP_HEADER = "X-ProxyScheme";
    public static final String PROXY_HOST_HTTP_HEADER = "X-ProxyHost";
    public static final String PROXY_PORT_HTTP_HEADER = "X-ProxyPort";
    public static final String FORWARDED_PROTO_HTTP_HEADER = "X-Forwarded-Proto";
    public static final String FORWARDED_HOST_HTTP_HEADER = "X-Forwarded-Host";
    public static final String FORWARDED_PORT_HTTP_HEADER = "X-Forwarded-Port";
    public static final String PROXY_CONTEXT_PATH_HTTP_HEADER = "X-ProxyContextPath";
    public static final String FORWARDED_CONTEXT_HTTP_HEADER = "X-Forwarded-Context";
    public static final String FORWARDED_PREFIX_HTTP_HEADER = "X-Forwarded-Prefix";
    private static final String HOST_HEADER = "Host";
    private static final String EMPTY = "";

    private WebUtils() {
    }

    public static Client createClient(ClientConfig config) {
        return WebUtils.createClientHelper(config, null);
    }

    public static Client createClient(ClientConfig config, SSLContext ctx) {
        return WebUtils.createClientHelper(config, ctx);
    }

    private static Client createClientHelper(ClientConfig config, SSLContext ctx) {
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        if (config != null) {
            clientBuilder = clientBuilder.withConfig((Configuration)config);
        }
        if (ctx != null) {
            clientBuilder = clientBuilder.sslContext(ctx).hostnameVerifier((HostnameVerifier)new DefaultHostnameVerifier());
        }
        clientBuilder = (ClientBuilder)((ClientBuilder)clientBuilder.register(ObjectMapperResolver.class)).register(JacksonJaxbJsonProvider.class);
        return clientBuilder.build();
    }

    public static void verifyContextPath(List<String> allowedContextPaths, String determinedContextPath) throws UriBuilderException {
        if (StringUtils.isBlank((CharSequence)determinedContextPath)) {
            return;
        }
        if (!allowedContextPaths.contains(determinedContextPath)) {
            String msg = "The provided context path [" + determinedContextPath + "] was not registered as allowed " + allowedContextPaths;
            throw new UriBuilderException(msg);
        }
    }

    public static String normalizeContextPath(String determinedContextPath) {
        if (StringUtils.isNotBlank((CharSequence)determinedContextPath)) {
            if (!((String)determinedContextPath).startsWith("/")) {
                determinedContextPath = "/" + (String)determinedContextPath;
            }
            if (((String)determinedContextPath).endsWith("/")) {
                determinedContextPath = ((String)determinedContextPath).substring(0, ((String)determinedContextPath).length() - 1);
            }
            return determinedContextPath;
        }
        return EMPTY;
    }

    public static String sanitizeContextPath(ServletRequest request, List<String> allowedContextPaths, String jspDisplayName) {
        if (StringUtils.isBlank((CharSequence)jspDisplayName)) {
            jspDisplayName = "JSP page";
        }
        String contextPath = WebUtils.normalizeContextPath(WebUtils.determineContextPath((HttpServletRequest)request));
        try {
            WebUtils.verifyContextPath(allowedContextPaths, contextPath);
            return contextPath;
        }
        catch (UriBuilderException e) {
            logger.error("Error determining context path on " + jspDisplayName + ": " + e.getMessage());
            return EMPTY;
        }
    }

    public static String determineContextPath(HttpServletRequest request) {
        String proxyContextPath = request.getHeader(PROXY_CONTEXT_PATH_HTTP_HEADER);
        String forwardedContext = request.getHeader(FORWARDED_CONTEXT_HTTP_HEADER);
        String prefix = request.getHeader(FORWARDED_PREFIX_HTTP_HEADER);
        String determinedContextPath = EMPTY;
        if (WebUtils.anyNotBlank(proxyContextPath, forwardedContext, prefix)) {
            determinedContextPath = Stream.of(proxyContextPath, forwardedContext, prefix).filter(StringUtils::isNotBlank).findFirst().orElse(EMPTY);
        }
        return determinedContextPath;
    }

    private static boolean anyNotBlank(String ... strings) {
        for (String s : strings) {
            if (!StringUtils.isNotBlank((CharSequence)s)) continue;
            return true;
        }
        return false;
    }

    public static String getFirstHeaderValue(HttpServletRequest httpServletRequest, String ... keys) {
        if (keys == null) {
            return null;
        }
        for (String key : keys) {
            String value = httpServletRequest.getHeader(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static String determineProxiedScheme(HttpServletRequest httpServletRequest) {
        String schemeHeaderValue = WebUtils.getFirstHeaderValue(httpServletRequest, PROXY_SCHEME_HTTP_HEADER, FORWARDED_PROTO_HTTP_HEADER);
        return StringUtils.isBlank((CharSequence)schemeHeaderValue) ? httpServletRequest.getScheme() : schemeHeaderValue;
    }

    public static String determineProxiedHost(HttpServletRequest httpServletRequest) {
        String hostHeaderValue = WebUtils.getFirstHeaderValue(httpServletRequest, PROXY_HOST_HTTP_HEADER, FORWARDED_HOST_HTTP_HEADER, HOST_HEADER);
        String proxiedHost = WebUtils.determineProxiedHost(hostHeaderValue);
        return StringUtils.isBlank((CharSequence)proxiedHost) ? httpServletRequest.getServerName() : proxiedHost;
    }

    public static String determineProxiedHost(String hostHeaderValue) {
        String[] hostSplits;
        String[] stringArray = hostSplits = hostHeaderValue == null ? new String[]{} : hostHeaderValue.split(":");
        String host = hostSplits.length >= 1 && hostSplits.length <= 2 ? hostSplits[0] : (hostSplits.length == 0 ? null : hostHeaderValue);
        return host;
    }

    public static int getServerPort(HttpServletRequest httpServletRequest) {
        String port = WebUtils.determineProxiedPort(httpServletRequest);
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            return httpServletRequest.getServerPort();
        }
    }

    public static String determineProxiedPort(HttpServletRequest httpServletRequest) {
        String hostHeaderValue = WebUtils.getFirstHeaderValue(httpServletRequest, PROXY_HOST_HTTP_HEADER, FORWARDED_HOST_HTTP_HEADER);
        String portHeaderValue = WebUtils.getFirstHeaderValue(httpServletRequest, PROXY_PORT_HTTP_HEADER, FORWARDED_PORT_HTTP_HEADER);
        String proxiedPort = WebUtils.determineProxiedPort(hostHeaderValue, portHeaderValue);
        return StringUtils.isBlank((CharSequence)proxiedPort) ? String.valueOf(httpServletRequest.getServerPort()) : proxiedPort;
    }

    public static String determineProxiedPort(String hostHeaderValue, String portHeaderValue) {
        String[] hostSplits = hostHeaderValue == null ? new String[]{} : hostHeaderValue.split(":");
        String portFromHostHeader = hostSplits.length == 2 ? hostSplits[1] : null;
        if (StringUtils.isNotBlank((CharSequence)portFromHostHeader) && StringUtils.isNotBlank((CharSequence)portHeaderValue)) {
            logger.warn("Forwarded Host Port [{}] replaced with Forwarded Port [{}]", (Object)portFromHostHeader, (Object)portHeaderValue);
        }
        String port = StringUtils.isNotBlank((CharSequence)portHeaderValue) ? portHeaderValue : (StringUtils.isNotBlank((CharSequence)portFromHostHeader) ? portFromHostHeader : null);
        return port;
    }
}

