/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.oidc.web.authentication;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.nifi.authorization.util.IdentityMapping;
import org.apache.nifi.web.security.cookie.ApplicationCookieName;
import org.apache.nifi.web.security.jwt.provider.BearerTokenProvider;
import org.apache.nifi.web.security.oidc.client.web.OidcRegistrationProperty;
import org.apache.nifi.web.security.oidc.client.web.converter.StandardOAuth2AuthenticationToken;
import org.apache.nifi.web.security.oidc.web.authentication.OidcAuthenticationSuccessHandler;
import org.apache.nifi.web.security.token.LoginAuthenticationToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;

@ExtendWith(value={MockitoExtension.class})
class OidcAuthenticationSuccessHandlerTest {
    @Mock
    OidcUser oidcUser;
    @Mock
    BearerTokenProvider bearerTokenProvider;
    @Captor
    ArgumentCaptor<LoginAuthenticationToken> authenticationTokenCaptor;
    MockHttpServletRequest httpServletRequest;
    MockHttpServletResponse httpServletResponse;
    OidcAuthenticationSuccessHandler handler;
    private static final String REQUEST_URI = "/nifi-api";
    private static final String UI_PATH = "/nifi/";
    private static final String ROOT_PATH = "/";
    private static final int SERVER_PORT = 8080;
    private static final String LOCALHOST_URL = "http://localhost:8080";
    private static final String TARGET_URL = String.format("%s%s", "http://localhost:8080", "/nifi/");
    private static final String USER_NAME_CLAIM = "email";
    private static final String GROUPS_CLAIM = "groups";
    private static final String IDENTITY = Authentication.class.getSimpleName();
    private static final String AUTHORITY = GrantedAuthority.class.getSimpleName();
    private static final String ACCESS_TOKEN = "access-token";
    private static final Duration TOKEN_EXPIRATION = Duration.ofHours(1L);
    private static final Instant ACCESS_TOKEN_ISSUED = Instant.ofEpochSecond(0L);
    private static final Instant ACCESS_TOKEN_EXPIRES = ACCESS_TOKEN_ISSUED.plus(TOKEN_EXPIRATION);
    private static final String FIRST_GROUP = "$1";
    private static final Pattern MATCH_PATTERN = Pattern.compile("(.*)");
    static final String FORWARDED_PATH = "/forwarded";
    static final String FORWARDED_COOKIE_PATH = String.format("%s/", "/forwarded");
    private static final String FORWARDED_TARGET_URL = String.format("%s%s%s", "http://localhost:8080", "/forwarded", "/nifi/");
    private static final String ALLOWED_CONTEXT_PATHS_PARAMETER = "allowedContextPaths";
    private static final IdentityMapping UPPER_IDENTITY_MAPPING = new IdentityMapping(IdentityMapping.Transform.UPPER.toString(), MATCH_PATTERN, "$1", IdentityMapping.Transform.UPPER);
    private static final IdentityMapping LOWER_IDENTITY_MAPPING = new IdentityMapping(IdentityMapping.Transform.LOWER.toString(), MATCH_PATTERN, "$1", IdentityMapping.Transform.LOWER);

    OidcAuthenticationSuccessHandlerTest() {
    }

    @BeforeEach
    void setHandler() {
        this.handler = new OidcAuthenticationSuccessHandler(this.bearerTokenProvider, Collections.singletonList(UPPER_IDENTITY_MAPPING), Collections.singletonList(LOWER_IDENTITY_MAPPING), Collections.singletonList(USER_NAME_CLAIM), GROUPS_CLAIM);
        this.httpServletRequest = new MockHttpServletRequest();
        this.httpServletRequest.setServerPort(8080);
        this.httpServletResponse = new MockHttpServletResponse();
    }

    @Test
    void testDetermineTargetUrl() {
        this.httpServletRequest.setRequestURI(REQUEST_URI);
        this.assertTargetUrlEquals(TARGET_URL);
        this.assertBearerCookieAdded(ROOT_PATH);
    }

    @Test
    void testDetermineTargetUrlForwardedPath() {
        ServletContext servletContext = this.httpServletRequest.getServletContext();
        servletContext.setInitParameter(ALLOWED_CONTEXT_PATHS_PARAMETER, FORWARDED_PATH);
        this.httpServletRequest.addHeader("X-Forwarded-Prefix", (Object)FORWARDED_PATH);
        this.httpServletRequest.setRequestURI(REQUEST_URI);
        this.assertTargetUrlEquals(FORWARDED_TARGET_URL);
        this.assertBearerCookieAdded(FORWARDED_COOKIE_PATH);
    }

    void assertTargetUrlEquals(String expectedTargetUrl) {
        this.setOidcUser();
        StandardOAuth2AuthenticationToken authentication = this.getAuthenticationToken();
        String targetUrl = this.handler.determineTargetUrl((HttpServletRequest)this.httpServletRequest, (HttpServletResponse)this.httpServletResponse, (Authentication)authentication);
        Assertions.assertEquals((Object)expectedTargetUrl, (Object)targetUrl);
    }

    void assertBearerCookieAdded(String expectedCookiePath) {
        Cookie responseCookie = this.httpServletResponse.getCookie(ApplicationCookieName.AUTHORIZATION_BEARER.getCookieName());
        Assertions.assertNotNull((Object)responseCookie);
        Assertions.assertEquals((Object)expectedCookiePath, (Object)responseCookie.getPath());
        ((BearerTokenProvider)Mockito.verify((Object)this.bearerTokenProvider)).getBearerToken((LoginAuthenticationToken)this.authenticationTokenCaptor.capture());
        LoginAuthenticationToken authenticationToken = (LoginAuthenticationToken)this.authenticationTokenCaptor.getValue();
        Instant expiration = authenticationToken.getExpiration();
        ChronoUnit truncation = ChronoUnit.MINUTES;
        Instant expirationTruncated = expiration.truncatedTo(truncation);
        Assertions.assertEquals((Object)ACCESS_TOKEN_EXPIRES, (Object)expirationTruncated);
    }

    void setOidcUser() {
        Mockito.when((Object)this.oidcUser.getClaimAsString((String)ArgumentMatchers.eq((Object)USER_NAME_CLAIM))).thenReturn((Object)IDENTITY);
        Mockito.when((Object)this.oidcUser.getClaimAsStringList((String)ArgumentMatchers.eq((Object)GROUPS_CLAIM))).thenReturn(Collections.singletonList(AUTHORITY));
    }

    StandardOAuth2AuthenticationToken getAuthenticationToken() {
        OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, ACCESS_TOKEN, ACCESS_TOKEN_ISSUED, ACCESS_TOKEN_EXPIRES);
        List<SimpleGrantedAuthority> authorities = Collections.singletonList(new SimpleGrantedAuthority(AUTHORITY));
        return new StandardOAuth2AuthenticationToken((OAuth2User)this.oidcUser, authorities, OidcRegistrationProperty.REGISTRATION_ID.getProperty(), accessToken);
    }
}

