/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.csrf;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.UUID;
import org.apache.nifi.web.security.csrf.SkipReplicatedCsrfFilter;
import org.apache.nifi.web.security.http.SecurityCookieName;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.http.HttpMethod;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.web.csrf.CsrfFilter;

@ExtendWith(value={MockitoExtension.class})
class SkipReplicatedCsrfFilterTest {
    private static final String SHOULD_NOT_FILTER = String.format("SHOULD_NOT_FILTER%s", CsrfFilter.class.getName());
    MockHttpServletRequest httpServletRequest;
    MockHttpServletResponse httpServletResponse;
    @Mock
    FilterChain filterChain;
    SkipReplicatedCsrfFilter filter;

    SkipReplicatedCsrfFilterTest() {
    }

    @BeforeEach
    void setHandler() {
        this.filter = new SkipReplicatedCsrfFilter();
        this.httpServletRequest = new MockHttpServletRequest();
        this.httpServletResponse = new MockHttpServletResponse();
    }

    @Test
    void testDoFilterInternalNotSkipped() throws ServletException, IOException {
        this.httpServletRequest.setMethod(HttpMethod.GET.name());
        this.filter.doFilterInternal((HttpServletRequest)this.httpServletRequest, (HttpServletResponse)this.httpServletResponse, this.filterChain);
        this.assertCsrfFilterNotSkipped();
    }

    @Test
    void testDoFilterInternalBearerCookieNotSkipped() throws ServletException, IOException {
        this.httpServletRequest.setMethod(HttpMethod.GET.name());
        Cookie bearerCookie = new Cookie(SecurityCookieName.AUTHORIZATION_BEARER.getName(), UUID.randomUUID().toString());
        this.httpServletRequest.setCookies(new Cookie[]{bearerCookie});
        this.filter.doFilterInternal((HttpServletRequest)this.httpServletRequest, (HttpServletResponse)this.httpServletResponse, this.filterChain);
        this.assertCsrfFilterNotSkipped();
    }

    @Test
    void testDoFilterInternalReplicatedHeaderAndBearerCookieNotSkipped() throws ServletException, IOException {
        this.httpServletRequest.setMethod(HttpMethod.GET.name());
        this.httpServletRequest.addHeader("X-RequestTransactionId", (Object)UUID.randomUUID().toString());
        Cookie bearerCookie = new Cookie(SecurityCookieName.AUTHORIZATION_BEARER.getName(), UUID.randomUUID().toString());
        this.httpServletRequest.setCookies(new Cookie[]{bearerCookie});
        this.filter.doFilterInternal((HttpServletRequest)this.httpServletRequest, (HttpServletResponse)this.httpServletResponse, this.filterChain);
        this.assertCsrfFilterNotSkipped();
    }

    @Test
    void testDoFilterInternalReplicatedHeaderSkipped() throws ServletException, IOException {
        this.httpServletRequest.setMethod(HttpMethod.GET.name());
        this.httpServletRequest.addHeader("X-RequestTransactionId", (Object)UUID.randomUUID().toString());
        this.filter.doFilterInternal((HttpServletRequest)this.httpServletRequest, (HttpServletResponse)this.httpServletResponse, this.filterChain);
        Object shouldNotFilter = this.httpServletRequest.getAttribute(SHOULD_NOT_FILTER);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)shouldNotFilter);
        ((FilterChain)Mockito.verify((Object)this.filterChain)).doFilter((ServletRequest)ArgumentMatchers.eq((Object)this.httpServletRequest), (ServletResponse)ArgumentMatchers.eq((Object)this.httpServletResponse));
    }

    private void assertCsrfFilterNotSkipped() throws ServletException, IOException {
        Object shouldNotFilter = this.httpServletRequest.getAttribute(SHOULD_NOT_FILTER);
        Assertions.assertNotEquals((Object)Boolean.TRUE, (Object)shouldNotFilter);
        ((FilterChain)Mockito.verify((Object)this.filterChain)).doFilter((ServletRequest)ArgumentMatchers.eq((Object)this.httpServletRequest), (ServletResponse)ArgumentMatchers.eq((Object)this.httpServletResponse));
    }
}

