/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.nifi.web.security.StandardAuthenticationEntryPoint;
import org.apache.nifi.web.security.cookie.ApplicationCookieName;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.server.resource.InvalidBearerTokenException;
import org.springframework.security.oauth2.server.resource.web.BearerTokenAuthenticationEntryPoint;

class StandardAuthenticationEntryPointTest {
    static final String FAILED = "Authentication Failed";
    static final String BEARER_TOKEN = "Bearer Token";
    static final String ROOT_PATH = "/";
    static final String FORWARDED_PATH = "/forwarded";
    static final String FORWARDED_COOKIE_PATH = String.format("%s/", "/forwarded");
    private static final String ALLOWED_CONTEXT_PATHS_PARAMETER = "allowedContextPaths";
    MockHttpServletRequest request;
    MockHttpServletResponse response;
    StandardAuthenticationEntryPoint authenticationEntryPoint;

    StandardAuthenticationEntryPointTest() {
    }

    @BeforeEach
    void setAuthenticationEntryPoint() {
        BearerTokenAuthenticationEntryPoint bearerTokenAuthenticationEntryPoint = new BearerTokenAuthenticationEntryPoint();
        this.authenticationEntryPoint = new StandardAuthenticationEntryPoint(bearerTokenAuthenticationEntryPoint);
        this.request = new MockHttpServletRequest();
        this.response = new MockHttpServletResponse();
    }

    @Test
    void testCommenceAuthenticationServiceException() throws IOException {
        AuthenticationServiceException exception = new AuthenticationServiceException(FAILED);
        this.authenticationEntryPoint.commence((HttpServletRequest)this.request, (HttpServletResponse)this.response, (AuthenticationException)exception);
        Assertions.assertEquals((int)401, (int)this.response.getStatus());
        String authenticateHeader = this.response.getHeader("WWW-Authenticate");
        Assertions.assertNull((Object)authenticateHeader);
        Cookie cookie = this.response.getCookie(ApplicationCookieName.AUTHORIZATION_BEARER.getCookieName());
        Assertions.assertNull((Object)cookie);
        String content = this.response.getContentAsString();
        Assertions.assertEquals((Object)"Unauthorized", (Object)content);
    }

    @Test
    void testCommenceOAuth2AuthenticationException() throws IOException {
        OAuth2AuthenticationException exception = new OAuth2AuthenticationException(FAILED);
        this.authenticationEntryPoint.commence((HttpServletRequest)this.request, (HttpServletResponse)this.response, (AuthenticationException)exception);
        Assertions.assertEquals((int)401, (int)this.response.getStatus());
        String authenticateHeader = this.response.getHeader("WWW-Authenticate");
        Assertions.assertNotNull((Object)authenticateHeader);
        Assertions.assertTrue((boolean)authenticateHeader.startsWith("Bearer"), (String)"Bearer header not found");
        Assertions.assertTrue((boolean)authenticateHeader.contains(FAILED), (String)"Header error message not found");
        Cookie cookie = this.response.getCookie(ApplicationCookieName.AUTHORIZATION_BEARER.getCookieName());
        Assertions.assertNull((Object)cookie);
        String content = this.response.getContentAsString();
        Assertions.assertTrue((boolean)content.startsWith("Unauthorized"), (String)"Unauthorized message not found");
        Assertions.assertTrue((boolean)content.contains(FAILED), (String)"Response error message not found");
    }

    @Test
    void testCommenceInvalidBearerTokenExceptionExpired() throws IOException {
        InvalidBearerTokenException exception = new InvalidBearerTokenException("Expired JWT");
        this.authenticationEntryPoint.commence((HttpServletRequest)this.request, (HttpServletResponse)this.response, (AuthenticationException)exception);
        Assertions.assertEquals((int)401, (int)this.response.getStatus());
        String authenticateHeader = this.response.getHeader("WWW-Authenticate");
        Assertions.assertNotNull((Object)authenticateHeader);
        Assertions.assertTrue((boolean)authenticateHeader.startsWith("Bearer"), (String)"Bearer header not found");
        Assertions.assertTrue((boolean)authenticateHeader.contains("Expired JWT"), (String)"Header error message not found");
        Cookie cookie = this.response.getCookie(ApplicationCookieName.AUTHORIZATION_BEARER.getCookieName());
        Assertions.assertNull((Object)cookie);
        String content = this.response.getContentAsString();
        Assertions.assertEquals((Object)"Session Expired", (Object)content);
    }

    @Test
    void testCommenceRemoveCookie() throws IOException {
        AuthenticationServiceException exception = new AuthenticationServiceException(FAILED);
        Cookie cookie = new Cookie(ApplicationCookieName.AUTHORIZATION_BEARER.getCookieName(), BEARER_TOKEN);
        this.request.setCookies(new Cookie[]{cookie});
        this.authenticationEntryPoint.commence((HttpServletRequest)this.request, (HttpServletResponse)this.response, (AuthenticationException)exception);
        this.assertResponseStatusUnauthorized();
        this.assertBearerCookieRemoved(ROOT_PATH);
    }

    @Test
    void testCommenceRemoveCookieForwardedPath() throws IOException {
        AuthenticationServiceException exception = new AuthenticationServiceException(FAILED);
        ServletContext servletContext = this.request.getServletContext();
        servletContext.setInitParameter(ALLOWED_CONTEXT_PATHS_PARAMETER, FORWARDED_PATH);
        this.request.addHeader("X-Forwarded-Prefix", (Object)FORWARDED_PATH);
        Cookie cookie = new Cookie(ApplicationCookieName.AUTHORIZATION_BEARER.getCookieName(), BEARER_TOKEN);
        this.request.setCookies(new Cookie[]{cookie});
        this.authenticationEntryPoint.commence((HttpServletRequest)this.request, (HttpServletResponse)this.response, (AuthenticationException)exception);
        this.assertResponseStatusUnauthorized();
        this.assertBearerCookieRemoved(FORWARDED_COOKIE_PATH);
    }

    void assertResponseStatusUnauthorized() throws UnsupportedEncodingException {
        Assertions.assertEquals((int)401, (int)this.response.getStatus());
        String content = this.response.getContentAsString();
        Assertions.assertEquals((Object)"Unauthorized", (Object)content);
    }

    void assertBearerCookieRemoved(String expectedCookiePath) {
        Cookie responseCookie = this.response.getCookie(ApplicationCookieName.AUTHORIZATION_BEARER.getCookieName());
        Assertions.assertNotNull((Object)responseCookie);
        Assertions.assertEquals((Object)expectedCookiePath, (Object)responseCookie.getPath());
    }
}

