/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.oidc.revocation;

import java.util.LinkedHashMap;
import org.apache.nifi.web.security.oidc.client.web.OidcRegistrationProperty;
import org.apache.nifi.web.security.oidc.revocation.StandardTokenRevocationResponseClient;
import org.apache.nifi.web.security.oidc.revocation.TokenRevocationRequest;
import org.apache.nifi.web.security.oidc.revocation.TokenRevocationResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.web.client.RestOperations;

@ExtendWith(value={MockitoExtension.class})
class StandardTokenRevocationResponseClientTest {
    private static final String CLIENT_ID = "client-id";
    private static final String CLIENT_SECRET = "client-secret";
    private static final String REDIRECT_URI = "http://localhost:8080";
    private static final String AUTHORIZATION_URI = "http://localhost/authorize";
    private static final String TOKEN_URI = "http://localhost/token";
    private static final String REVOCATION_ENDPOINT_URI = "http://localhost/revoke";
    private static final String TOKEN = "token";
    private static final String TOKEN_TYPE_HINT = "refresh_token";
    @Mock
    RestOperations restOperations;
    @Mock
    ClientRegistrationRepository clientRegistrationRepository;
    StandardTokenRevocationResponseClient client;

    StandardTokenRevocationResponseClientTest() {
    }

    @BeforeEach
    void setClient() {
        this.client = new StandardTokenRevocationResponseClient(this.restOperations, this.clientRegistrationRepository);
    }

    @Test
    void testGetRevocationResponseEndpointNotFound() {
        TokenRevocationRequest revocationRequest = new TokenRevocationRequest(TOKEN, TOKEN_TYPE_HINT);
        ClientRegistration clientRegistration = this.getClientRegistration(null);
        Mockito.when((Object)this.clientRegistrationRepository.findByRegistrationId((String)ArgumentMatchers.eq((Object)OidcRegistrationProperty.REGISTRATION_ID.getProperty()))).thenReturn((Object)clientRegistration);
        TokenRevocationResponse revocationResponse = this.client.getRevocationResponse(revocationRequest);
        Assertions.assertNotNull((Object)revocationResponse);
        Assertions.assertTrue((boolean)revocationResponse.isSuccess());
    }

    @Test
    void testGetRevocationResponseException() {
        TokenRevocationRequest revocationRequest = new TokenRevocationRequest(TOKEN, TOKEN_TYPE_HINT);
        ClientRegistration clientRegistration = this.getClientRegistration(REVOCATION_ENDPOINT_URI);
        Mockito.when((Object)this.clientRegistrationRepository.findByRegistrationId((String)ArgumentMatchers.eq((Object)OidcRegistrationProperty.REGISTRATION_ID.getProperty()))).thenReturn((Object)clientRegistration);
        Mockito.when((Object)this.restOperations.exchange((RequestEntity)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(String.class))).thenThrow(new Throwable[]{new RuntimeException()});
        TokenRevocationResponse revocationResponse = this.client.getRevocationResponse(revocationRequest);
        Assertions.assertNotNull((Object)revocationResponse);
        Assertions.assertFalse((boolean)revocationResponse.isSuccess());
    }

    @Test
    void testGetRevocationResponse() {
        TokenRevocationRequest revocationRequest = new TokenRevocationRequest(TOKEN, TOKEN_TYPE_HINT);
        ClientRegistration clientRegistration = this.getClientRegistration(REVOCATION_ENDPOINT_URI);
        Mockito.when((Object)this.clientRegistrationRepository.findByRegistrationId((String)ArgumentMatchers.eq((Object)OidcRegistrationProperty.REGISTRATION_ID.getProperty()))).thenReturn((Object)clientRegistration);
        ResponseEntity responseEntity = ResponseEntity.ok().build();
        Mockito.when((Object)this.restOperations.exchange((RequestEntity)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(String.class))).thenReturn((Object)responseEntity);
        TokenRevocationResponse revocationResponse = this.client.getRevocationResponse(revocationRequest);
        Assertions.assertNotNull((Object)revocationResponse);
        Assertions.assertTrue((boolean)revocationResponse.isSuccess());
    }

    ClientRegistration getClientRegistration(String revocationEndpoint) {
        LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>();
        metadata.put("revocation_endpoint", revocationEndpoint);
        return ClientRegistration.withRegistrationId((String)OidcRegistrationProperty.REGISTRATION_ID.getProperty()).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).clientId(CLIENT_ID).clientSecret(CLIENT_SECRET).redirectUri(REDIRECT_URI).authorizationUri(AUTHORIZATION_URI).tokenUri(TOKEN_URI).providerConfigurationMetadata(metadata).build();
    }
}

