/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.oidc.client.web;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserDetails;
import org.apache.nifi.authorization.user.StandardNiFiUser;
import org.apache.nifi.web.security.cookie.ApplicationCookieName;
import org.apache.nifi.web.security.jwt.provider.BearerTokenProvider;
import org.apache.nifi.web.security.oidc.client.web.OidcAuthorizedClient;
import org.apache.nifi.web.security.oidc.client.web.OidcBearerTokenRefreshFilter;
import org.apache.nifi.web.security.oidc.client.web.OidcRegistrationProperty;
import org.apache.nifi.web.security.token.LoginAuthenticationToken;
import org.apache.nifi.web.security.token.NiFiAuthenticationToken;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2RefreshTokenGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;

@ExtendWith(value={MockitoExtension.class})
class OidcBearerTokenRefreshFilterTest {
    private static final String CLIENT_ID = "client-id";
    private static final String REDIRECT_URI = "http://localhost:8080";
    private static final String AUTHORIZATION_URI = "http://localhost/authorize";
    private static final String TOKEN_URI = "http://localhost/token";
    private static final String SUB_CLAIM = "sub";
    private static final String IDENTITY = "user-identity";
    private static final Duration REFRESH_WINDOW = Duration.ZERO;
    private static final String CURRENT_USER_URI = "/flow/current-user";
    private static final String BEARER_TOKEN = "bearer-token";
    private static final String BEARER_TOKEN_REFRESHED = "bearer-token-refreshed";
    private static final String ACCESS_TOKEN = "access-token";
    private static final String REFRESH_TOKEN = "refresh-token";
    private static final String ID_TOKEN = "id-token";
    private static final String EXP_CLAIM = "exp";
    private static final int INSTANT_OFFSET = 1;
    private static final String PROVIDER_GROUP = "Authorized";
    private static final Set<String> PROVIDER_GROUPS = Collections.singleton("Authorized");
    @Mock
    BearerTokenProvider bearerTokenProvider;
    @Mock
    BearerTokenResolver bearerTokenResolver;
    @Mock
    JwtDecoder jwtDecoder;
    @Mock
    OAuth2AuthorizedClientRepository authorizedClientRepository;
    @Mock
    OAuth2AccessTokenResponseClient<OAuth2RefreshTokenGrantRequest> refreshTokenResponseClient;
    @Mock
    OidcAuthorizedClient authorizedClient;
    @Captor
    ArgumentCaptor<LoginAuthenticationToken> tokenArgumentCaptor;
    MockHttpServletRequest request;
    MockHttpServletResponse response;
    MockFilterChain filterChain;
    OidcBearerTokenRefreshFilter filter;

    OidcBearerTokenRefreshFilterTest() {
    }

    @BeforeEach
    void setFilter() {
        this.filter = new OidcBearerTokenRefreshFilter(REFRESH_WINDOW, this.bearerTokenProvider, this.bearerTokenResolver, this.jwtDecoder, this.authorizedClientRepository, this.refreshTokenResponseClient);
        this.request = new MockHttpServletRequest();
        this.response = new MockHttpServletResponse();
        this.filterChain = new MockFilterChain();
    }

    @AfterEach
    void clearContext() {
        SecurityContextHolder.clearContext();
    }

    @Test
    void testDoFilterPathNotMatched() throws ServletException, IOException {
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)this.filterChain);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.bearerTokenResolver});
    }

    @Test
    void testDoFilterBearerTokenNotFound() throws ServletException, IOException {
        this.request.setServletPath(CURRENT_USER_URI);
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)this.filterChain);
        ((BearerTokenResolver)Mockito.verify((Object)this.bearerTokenResolver)).resolve((HttpServletRequest)ArgumentMatchers.eq((Object)this.request));
    }

    @Test
    void testDoFilterBearerTokenFoundRefreshNotRequired() throws ServletException, IOException {
        this.request.setServletPath(CURRENT_USER_URI);
        Mockito.when((Object)this.bearerTokenResolver.resolve((HttpServletRequest)ArgumentMatchers.eq((Object)this.request))).thenReturn((Object)BEARER_TOKEN);
        Jwt jwt = this.getJwt(Instant.MAX);
        Mockito.when((Object)this.jwtDecoder.decode((String)ArgumentMatchers.eq((Object)BEARER_TOKEN))).thenReturn((Object)jwt);
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)this.filterChain);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.authorizedClientRepository});
    }

    @Test
    void testDoFilterRefreshRequiredClientNotFound() throws ServletException, IOException {
        this.request.setServletPath(CURRENT_USER_URI);
        Mockito.when((Object)this.bearerTokenResolver.resolve((HttpServletRequest)ArgumentMatchers.eq((Object)this.request))).thenReturn((Object)BEARER_TOKEN);
        Jwt jwt = this.getJwt(Instant.now().minusSeconds(1L));
        Mockito.when((Object)this.jwtDecoder.decode((String)ArgumentMatchers.eq((Object)BEARER_TOKEN))).thenReturn((Object)jwt);
        Mockito.when((Object)this.authorizedClientRepository.loadAuthorizedClient((String)ArgumentMatchers.eq((Object)OidcRegistrationProperty.REGISTRATION_ID.getProperty()), (Authentication)ArgumentMatchers.any(), (HttpServletRequest)ArgumentMatchers.eq((Object)this.request))).thenReturn(null);
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)this.filterChain);
        Cookie cookie = this.response.getCookie(ApplicationCookieName.AUTHORIZATION_BEARER.getCookieName());
        Assertions.assertNull((Object)cookie);
    }

    @Test
    void testDoFilterRefreshRequiredRefreshTokenNotFound() throws ServletException, IOException {
        this.request.setServletPath(CURRENT_USER_URI);
        Mockito.when((Object)this.bearerTokenResolver.resolve((HttpServletRequest)ArgumentMatchers.eq((Object)this.request))).thenReturn((Object)BEARER_TOKEN);
        Jwt jwt = this.getJwt(Instant.now().minusSeconds(1L));
        Mockito.when((Object)this.jwtDecoder.decode((String)ArgumentMatchers.eq((Object)BEARER_TOKEN))).thenReturn((Object)jwt);
        Mockito.when((Object)this.authorizedClientRepository.loadAuthorizedClient((String)ArgumentMatchers.eq((Object)OidcRegistrationProperty.REGISTRATION_ID.getProperty()), (Authentication)ArgumentMatchers.any(), (HttpServletRequest)ArgumentMatchers.eq((Object)this.request))).thenReturn((Object)this.authorizedClient);
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)this.filterChain);
        Cookie cookie = this.response.getCookie(ApplicationCookieName.AUTHORIZATION_BEARER.getCookieName());
        Assertions.assertNull((Object)cookie);
    }

    @Test
    void testDoFilterBearerTokenTokenRefreshed() throws ServletException, IOException {
        StandardNiFiUser user = new StandardNiFiUser.Builder().identity(IDENTITY).identityProviderGroups(PROVIDER_GROUPS).build();
        NiFiUserDetails userDetails = new NiFiUserDetails((NiFiUser)user);
        NiFiAuthenticationToken authenticationToken = new NiFiAuthenticationToken((UserDetails)userDetails);
        SecurityContextImpl securityContext = new SecurityContextImpl((Authentication)authenticationToken);
        SecurityContextHolder.setContext((SecurityContext)securityContext);
        this.request.setServletPath(CURRENT_USER_URI);
        Mockito.when((Object)this.bearerTokenResolver.resolve((HttpServletRequest)ArgumentMatchers.eq((Object)this.request))).thenReturn((Object)BEARER_TOKEN);
        Instant expiration = Instant.now().minusSeconds(1L);
        Jwt jwt = this.getJwt(expiration);
        Mockito.when((Object)this.jwtDecoder.decode((String)ArgumentMatchers.eq((Object)BEARER_TOKEN))).thenReturn((Object)jwt);
        Instant issued = expiration.minus(Duration.ofHours(1L));
        OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, ACCESS_TOKEN, issued, expiration);
        OAuth2RefreshToken refreshToken = new OAuth2RefreshToken(REFRESH_TOKEN, issued);
        Map<String, String> claims = Collections.singletonMap(SUB_CLAIM, IDENTITY);
        OidcIdToken idToken = new OidcIdToken(ID_TOKEN, issued, expiration, claims);
        Mockito.when((Object)this.authorizedClient.getAccessToken()).thenReturn((Object)accessToken);
        Mockito.when((Object)this.authorizedClient.getRefreshToken()).thenReturn((Object)refreshToken);
        Mockito.when((Object)this.authorizedClient.getIdToken()).thenReturn((Object)idToken);
        Mockito.when((Object)this.authorizedClient.getClientRegistration()).thenReturn((Object)this.getClientRegistration());
        Mockito.when((Object)this.authorizedClient.getPrincipalName()).thenReturn((Object)IDENTITY);
        Mockito.when((Object)this.authorizedClientRepository.loadAuthorizedClient((String)ArgumentMatchers.eq((Object)OidcRegistrationProperty.REGISTRATION_ID.getProperty()), (Authentication)ArgumentMatchers.any(), (HttpServletRequest)ArgumentMatchers.eq((Object)this.request))).thenReturn((Object)this.authorizedClient);
        OAuth2AccessTokenResponse tokenResponse = OAuth2AccessTokenResponse.withToken((String)ACCESS_TOKEN).tokenType(OAuth2AccessToken.TokenType.BEARER).expiresIn(1L).build();
        Mockito.when((Object)this.refreshTokenResponseClient.getTokenResponse((AbstractOAuth2AuthorizationGrantRequest)((OAuth2RefreshTokenGrantRequest)ArgumentMatchers.any()))).thenReturn((Object)tokenResponse);
        Mockito.when((Object)this.bearerTokenProvider.getBearerToken((LoginAuthenticationToken)this.tokenArgumentCaptor.capture())).thenReturn((Object)BEARER_TOKEN_REFRESHED);
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)this.filterChain);
        Cookie cookie = this.response.getCookie(ApplicationCookieName.AUTHORIZATION_BEARER.getCookieName());
        Assertions.assertNotNull((Object)cookie);
        Assertions.assertEquals((Object)BEARER_TOKEN_REFRESHED, (Object)cookie.getValue());
        LoginAuthenticationToken loginAuthenticationToken = (LoginAuthenticationToken)this.tokenArgumentCaptor.getValue();
        Iterator authorities = loginAuthenticationToken.getAuthorities().iterator();
        Assertions.assertTrue((boolean)authorities.hasNext());
        GrantedAuthority authority = (GrantedAuthority)authorities.next();
        Assertions.assertEquals((Object)PROVIDER_GROUP, (Object)authority.getAuthority());
    }

    private Jwt getJwt(Instant expiration) {
        Map<String, Instant> claims = Collections.singletonMap(EXP_CLAIM, expiration);
        Instant issued = expiration.minus(Duration.ofHours(1L));
        return new Jwt(BEARER_TOKEN, issued, expiration, claims, claims);
    }

    ClientRegistration getClientRegistration() {
        return ClientRegistration.withRegistrationId((String)OidcRegistrationProperty.REGISTRATION_ID.getProperty()).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).clientId(CLIENT_ID).redirectUri(REDIRECT_URI).authorizationUri(AUTHORIZATION_URI).tokenUri(TOKEN_URI).userNameAttributeName(SUB_CLAIM).build();
    }
}

