/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.saml2.web.authentication.logout;

import java.io.IOException;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.nifi.web.security.cookie.ApplicationCookieName;
import org.apache.nifi.web.security.logout.LogoutRequest;
import org.apache.nifi.web.security.logout.LogoutRequestManager;
import org.apache.nifi.web.security.saml2.web.authentication.logout.Saml2LogoutSuccessHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.core.Authentication;

@ExtendWith(value={MockitoExtension.class})
class Saml2LogoutSuccessHandlerTest {
    private static final String REQUEST_IDENTIFIER = UUID.randomUUID().toString();
    private static final String USER_IDENTITY = LogoutRequest.class.getSimpleName();
    private static final String REQUEST_URI = "/nifi-api";
    private static final int SERVER_PORT = 8080;
    private static final String REDIRECTED_URL = "http://localhost:8080/nifi/logout-complete";
    @Mock
    Authentication authentication;
    MockHttpServletRequest httpServletRequest;
    MockHttpServletResponse httpServletResponse;
    LogoutRequestManager logoutRequestManager;
    Saml2LogoutSuccessHandler handler;

    Saml2LogoutSuccessHandlerTest() {
    }

    @BeforeEach
    void setHandler() {
        this.logoutRequestManager = new LogoutRequestManager();
        this.handler = new Saml2LogoutSuccessHandler(this.logoutRequestManager);
        this.httpServletRequest = new MockHttpServletRequest();
        this.httpServletRequest.setServerPort(8080);
        this.httpServletResponse = new MockHttpServletResponse();
    }

    @Test
    void testOnLogoutSuccessRequestNotFound() throws IOException {
        Cookie cookie = new Cookie(ApplicationCookieName.LOGOUT_REQUEST_IDENTIFIER.getCookieName(), REQUEST_IDENTIFIER);
        this.httpServletRequest.setCookies(new Cookie[]{cookie});
        this.httpServletRequest.setRequestURI(REQUEST_URI);
        this.handler.onLogoutSuccess((HttpServletRequest)this.httpServletRequest, (HttpServletResponse)this.httpServletResponse, this.authentication);
        String redirectedUrl = this.httpServletResponse.getRedirectedUrl();
        Assertions.assertEquals((Object)REDIRECTED_URL, (Object)redirectedUrl);
    }

    @Test
    void testOnLogoutSuccessRequestFound() throws IOException {
        Cookie cookie = new Cookie(ApplicationCookieName.LOGOUT_REQUEST_IDENTIFIER.getCookieName(), REQUEST_IDENTIFIER);
        this.httpServletRequest.setCookies(new Cookie[]{cookie});
        this.httpServletRequest.setRequestURI(REQUEST_URI);
        LogoutRequest logoutRequest = new LogoutRequest(REQUEST_IDENTIFIER, USER_IDENTITY);
        this.logoutRequestManager.start(logoutRequest);
        this.handler.onLogoutSuccess((HttpServletRequest)this.httpServletRequest, (HttpServletResponse)this.httpServletResponse, this.authentication);
        String redirectedUrl = this.httpServletResponse.getRedirectedUrl();
        Assertions.assertEquals((Object)REDIRECTED_URL, (Object)redirectedUrl);
    }
}

