/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.kerberos;

import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.core.Authentication;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.kerberos.authentication.KerberosServiceAuthenticationProvider;
import org.springframework.security.kerberos.authentication.KerberosServiceRequestToken;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;

public class KerberosService {
    private static final Logger logger = LoggerFactory.getLogger(KerberosService.class);
    public static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    public static final String AUTHENTICATION_CHALLENGE_HEADER_NAME = "WWW-Authenticate";
    public static final String AUTHORIZATION_NEGOTIATE = "Negotiate";
    private KerberosServiceAuthenticationProvider kerberosServiceAuthenticationProvider;
    private AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource = new WebAuthenticationDetailsSource();

    public void setKerberosServiceAuthenticationProvider(KerberosServiceAuthenticationProvider kerberosServiceAuthenticationProvider) {
        this.kerberosServiceAuthenticationProvider = kerberosServiceAuthenticationProvider;
    }

    public Authentication validateKerberosTicket(HttpServletRequest request) {
        if (!request.isSecure()) {
            return null;
        }
        String header = request.getHeader(AUTHORIZATION_HEADER_NAME);
        if (this.isValidKerberosHeader(header)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Received Negotiate Header for request " + request.getRequestURL() + ": " + header);
            }
            byte[] base64Token = header.substring(header.indexOf(" ") + 1).getBytes(StandardCharsets.UTF_8);
            byte[] kerberosTicket = Base64.decode((byte[])base64Token);
            KerberosServiceRequestToken authenticationRequest = new KerberosServiceRequestToken(kerberosTicket);
            authenticationRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
            return this.kerberosServiceAuthenticationProvider.authenticate((Authentication)authenticationRequest);
        }
        return null;
    }

    public boolean isValidKerberosHeader(String header) {
        return header != null && (header.startsWith("Negotiate ") || header.startsWith("Kerberos "));
    }
}

