/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.key;

import java.security.Key;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.nifi.web.security.jwt.jws.SigningKeyListener;
import org.apache.nifi.web.security.jwt.key.VerificationKeyListener;
import org.apache.nifi.web.security.jwt.key.VerificationKeySelector;
import org.apache.nifi.web.security.jwt.key.service.VerificationKeyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardVerificationKeySelector
implements SigningKeyListener,
VerificationKeyListener,
VerificationKeySelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardVerificationKeySelector.class);
    private final VerificationKeyService verificationKeyService;
    private final Duration keyRotationPeriod;

    public StandardVerificationKeySelector(VerificationKeyService verificationKeyService, Duration keyRotationPeriod) {
        this.verificationKeyService = Objects.requireNonNull(verificationKeyService, "Verification Key Service required");
        this.keyRotationPeriod = Objects.requireNonNull(keyRotationPeriod, "Key Rotation Period required");
    }

    @Override
    public void onVerificationKeyGenerated(String keyIdentifier, Key key) {
        Instant expiration = Instant.now().plus(this.keyRotationPeriod);
        this.verificationKeyService.save(keyIdentifier, key, expiration);
        LOGGER.debug("Verification Key Saved [{}] Expiration [{}]", (Object)keyIdentifier, (Object)expiration);
    }

    @Override
    public List<? extends Key> getVerificationKeys(String keyIdentifier) {
        Optional<Key> key = this.verificationKeyService.findById(keyIdentifier);
        List keys = key.map(Collections::singletonList).orElse(Collections.emptyList());
        LOGGER.debug("Key Identifier [{}] Verification Keys Found [{}]", (Object)keyIdentifier, (Object)keys.size());
        return keys;
    }

    @Override
    public void onSigningKeyUsed(String keyIdentifier, Instant expiration) {
        LOGGER.debug("Signing Key Used [{}] Expiration [{}]", (Object)keyIdentifier, (Object)expiration);
        this.verificationKeyService.setExpiration(keyIdentifier, expiration);
    }
}

