/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.revocation;

import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.web.security.jwt.revocation.StandardJwtRevocationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class StandardJwtRevocationServiceTest {
    private static final String ID = UUID.randomUUID().toString();
    private static final Scope SCOPE = Scope.LOCAL;
    private static final Instant EXPIRED = Instant.now().minusSeconds(60L);
    @Mock
    private StateManager stateManager;
    @Mock
    private StateMap stateMap;
    @Captor
    private ArgumentCaptor<Map<String, String>> stateCaptor;
    private StandardJwtRevocationService service;

    @Before
    public void setService() {
        this.service = new StandardJwtRevocationService(this.stateManager);
    }

    @Test
    public void testDeleteExpired() throws IOException {
        Mockito.when((Object)this.stateManager.getState((Scope)ArgumentMatchers.eq((Object)SCOPE))).thenReturn((Object)this.stateMap);
        Mockito.when((Object)this.stateMap.toMap()).thenReturn(Collections.singletonMap(ID, EXPIRED.toString()));
        this.service.deleteExpired();
        ((StateManager)Mockito.verify((Object)this.stateManager)).setState((Map)this.stateCaptor.capture(), (Scope)ArgumentMatchers.eq((Object)SCOPE));
        Map stateSaved = (Map)this.stateCaptor.getValue();
        Assert.assertTrue((String)"Expired Key not deleted", (boolean)stateSaved.isEmpty());
    }

    @Test
    public void testIsRevokedFound() throws IOException {
        Mockito.when((Object)this.stateManager.getState((Scope)ArgumentMatchers.eq((Object)SCOPE))).thenReturn((Object)this.stateMap);
        Mockito.when((Object)this.stateMap.toMap()).thenReturn(Collections.singletonMap(ID, EXPIRED.toString()));
        Assert.assertTrue((boolean)this.service.isRevoked(ID));
    }

    @Test
    public void testIsRevokedNotFound() throws IOException {
        Mockito.when((Object)this.stateManager.getState((Scope)ArgumentMatchers.eq((Object)SCOPE))).thenReturn((Object)this.stateMap);
        Mockito.when((Object)this.stateMap.toMap()).thenReturn(Collections.emptyMap());
        Assert.assertFalse((boolean)this.service.isRevoked(ID));
    }

    @Test
    public void testSetRevoked() throws IOException {
        Mockito.when((Object)this.stateManager.getState((Scope)ArgumentMatchers.eq((Object)SCOPE))).thenReturn((Object)this.stateMap);
        Mockito.when((Object)this.stateMap.toMap()).thenReturn(Collections.emptyMap());
        Instant expiration = Instant.now();
        this.service.setRevoked(ID, expiration);
        ((StateManager)Mockito.verify((Object)this.stateManager)).setState((Map)this.stateCaptor.capture(), (Scope)ArgumentMatchers.eq((Object)SCOPE));
        Map stateSaved = (Map)this.stateCaptor.getValue();
        String saved = (String)stateSaved.get(ID);
        Assert.assertEquals((String)"Expiration not matched", (Object)expiration.toString(), (Object)saved);
    }
}

