/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.cookie;

import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.web.security.cookie.ApplicationCookieName;
import org.apache.nifi.web.security.cookie.ApplicationCookieService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseCookie;
import org.springframework.web.util.WebUtils;

public class StandardApplicationCookieService
implements ApplicationCookieService {
    private static final Duration MAX_AGE_SESSION = Duration.ofSeconds(-1L);
    private static final Duration MAX_AGE_REMOVE = Duration.ZERO;
    private static final Duration MAX_AGE_STANDARD = Duration.ofSeconds(60L);
    private static final String DEFAULT_PATH = "/";
    private static final String SAME_SITE_STRICT = "Strict";
    private static final boolean SECURE_ENABLED = true;
    private static final boolean HTTP_ONLY_ENABLED = true;
    private static final Logger logger = LoggerFactory.getLogger(StandardApplicationCookieService.class);

    @Override
    public void addCookie(URI resourceUri, HttpServletResponse response, ApplicationCookieName applicationCookieName, String value) {
        ResponseCookie.ResponseCookieBuilder responseCookieBuilder = this.getCookieBuilder(resourceUri, applicationCookieName, value, MAX_AGE_STANDARD);
        this.setResponseCookie(response, responseCookieBuilder.build());
        logger.debug("Added Cookie [{}] URI [{}]", (Object)applicationCookieName.getCookieName(), (Object)resourceUri);
    }

    @Override
    public void addSessionCookie(URI resourceUri, HttpServletResponse response, ApplicationCookieName applicationCookieName, String value) {
        ResponseCookie.ResponseCookieBuilder responseCookieBuilder = this.getCookieBuilder(resourceUri, applicationCookieName, value, MAX_AGE_SESSION);
        responseCookieBuilder.sameSite(SAME_SITE_STRICT);
        this.setResponseCookie(response, responseCookieBuilder.build());
        logger.debug("Added Session Cookie [{}] URI [{}]", (Object)applicationCookieName.getCookieName(), (Object)resourceUri);
    }

    @Override
    public Optional<String> getCookieValue(HttpServletRequest request, ApplicationCookieName applicationCookieName) {
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)applicationCookieName.getCookieName());
        return cookie == null ? Optional.empty() : Optional.of(cookie.getValue());
    }

    @Override
    public void removeCookie(URI resourceUri, HttpServletResponse response, ApplicationCookieName applicationCookieName) {
        Objects.requireNonNull(response, "Response required");
        ResponseCookie.ResponseCookieBuilder responseCookieBuilder = this.getCookieBuilder(resourceUri, applicationCookieName, "", MAX_AGE_REMOVE);
        this.setResponseCookie(response, responseCookieBuilder.build());
        logger.debug("Removed Cookie [{}] URI [{}]", (Object)applicationCookieName.getCookieName(), (Object)resourceUri);
    }

    private ResponseCookie.ResponseCookieBuilder getCookieBuilder(URI resourceUri, ApplicationCookieName applicationCookieName, String value, Duration maxAge) {
        Objects.requireNonNull(resourceUri, "Resource URI required");
        Objects.requireNonNull(applicationCookieName, "Response Cookie Name required");
        return ResponseCookie.from((String)applicationCookieName.getCookieName(), (String)value).path(this.getCookiePath(resourceUri)).domain(resourceUri.getHost()).secure(true).httpOnly(true).maxAge(maxAge);
    }

    private void setResponseCookie(HttpServletResponse response, ResponseCookie responseCookie) {
        response.addHeader("Set-Cookie", responseCookie.toString());
    }

    private String getCookiePath(URI resourceUri) {
        return (String)StringUtils.defaultIfBlank((CharSequence)resourceUri.getPath(), (CharSequence)DEFAULT_PATH);
    }
}

