/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.saml2.service.web;

import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.nifi.web.security.cookie.ApplicationCookieName;
import org.apache.nifi.web.security.saml2.registration.Saml2RegistrationProperty;
import org.apache.nifi.web.security.saml2.service.web.StandardSaml2AuthenticationRequestRepository;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.cache.Cache;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.saml2.provider.service.authentication.AbstractSaml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2PostAuthenticationRequest;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;

@ExtendWith(value={MockitoExtension.class})
class StandardSaml2AuthenticationRequestRepositoryTest {
    private static final String REQUEST_IDENTIFIER = UUID.randomUUID().toString();
    private static final String LOCATION = "http://localhost/nifi-api";
    private static final String SAML_REQUEST = "<LoginRequest/>";
    @Mock
    Cache cache;
    MockHttpServletRequest httpServletRequest;
    MockHttpServletResponse httpServletResponse;
    private StandardSaml2AuthenticationRequestRepository repository;

    StandardSaml2AuthenticationRequestRepositoryTest() {
    }

    @BeforeEach
    void setRepository() {
        this.repository = new StandardSaml2AuthenticationRequestRepository(this.cache);
        this.httpServletRequest = new MockHttpServletRequest();
        this.httpServletResponse = new MockHttpServletResponse();
    }

    @Test
    void testLoadAuthenticationRequestCookieNotFound() {
        AbstractSaml2AuthenticationRequest request = this.repository.loadAuthenticationRequest((HttpServletRequest)this.httpServletRequest);
        Assertions.assertNull((Object)request);
    }

    @Test
    void testLoadAuthenticationRequestCacheNotFound() {
        Cookie cookie = new Cookie(ApplicationCookieName.SAML_REQUEST_IDENTIFIER.getCookieName(), REQUEST_IDENTIFIER);
        this.httpServletRequest.setCookies(new Cookie[]{cookie});
        AbstractSaml2AuthenticationRequest request = this.repository.loadAuthenticationRequest((HttpServletRequest)this.httpServletRequest);
        Assertions.assertNull((Object)request);
    }

    @Test
    void testLoadAuthenticationRequestFound() {
        Cookie cookie = new Cookie(ApplicationCookieName.SAML_REQUEST_IDENTIFIER.getCookieName(), REQUEST_IDENTIFIER);
        this.httpServletRequest.setCookies(new Cookie[]{cookie});
        AbstractSaml2AuthenticationRequest cachedRequest = this.getRequest();
        Mockito.when((Object)((AbstractSaml2AuthenticationRequest)this.cache.get(ArgumentMatchers.eq((Object)REQUEST_IDENTIFIER), (Class)ArgumentMatchers.eq(AbstractSaml2AuthenticationRequest.class)))).thenReturn((Object)cachedRequest);
        AbstractSaml2AuthenticationRequest request = this.repository.loadAuthenticationRequest((HttpServletRequest)this.httpServletRequest);
        Assertions.assertNotNull((Object)request);
    }

    @Test
    void testSaveAuthenticationRequest() {
        this.httpServletRequest.setRequestURI(LOCATION);
        AbstractSaml2AuthenticationRequest request = this.getRequest();
        this.repository.saveAuthenticationRequest(request, (HttpServletRequest)this.httpServletRequest, (HttpServletResponse)this.httpServletResponse);
        Cookie cookie = this.httpServletResponse.getCookie(ApplicationCookieName.SAML_REQUEST_IDENTIFIER.getCookieName());
        Assertions.assertNotNull((Object)cookie);
    }

    @Test
    void testRemoveAuthenticationRequestCookieNotFound() {
        AbstractSaml2AuthenticationRequest request = this.repository.removeAuthenticationRequest((HttpServletRequest)this.httpServletRequest, (HttpServletResponse)this.httpServletResponse);
        Assertions.assertNull((Object)request);
    }

    @Test
    void testRemoveAuthenticationRequestFound() {
        Cookie cookie = new Cookie(ApplicationCookieName.SAML_REQUEST_IDENTIFIER.getCookieName(), REQUEST_IDENTIFIER);
        this.httpServletRequest.setCookies(new Cookie[]{cookie});
        this.httpServletRequest.setRequestURI(LOCATION);
        AbstractSaml2AuthenticationRequest cachedRequest = this.getRequest();
        Mockito.when((Object)((AbstractSaml2AuthenticationRequest)this.cache.get(ArgumentMatchers.eq((Object)REQUEST_IDENTIFIER), (Class)ArgumentMatchers.eq(AbstractSaml2AuthenticationRequest.class)))).thenReturn((Object)cachedRequest);
        AbstractSaml2AuthenticationRequest request = this.repository.removeAuthenticationRequest((HttpServletRequest)this.httpServletRequest, (HttpServletResponse)this.httpServletResponse);
        Assertions.assertNotNull((Object)request);
    }

    private AbstractSaml2AuthenticationRequest getRequest() {
        RelyingPartyRegistration registration = RelyingPartyRegistration.withRegistrationId((String)Saml2RegistrationProperty.REGISTRATION_ID.getProperty()).entityId(Saml2RegistrationProperty.REGISTRATION_ID.getProperty()).assertingPartyDetails(assertingPartyDetails -> {
            assertingPartyDetails.entityId(Saml2RegistrationProperty.REGISTRATION_ID.getProperty());
            assertingPartyDetails.singleSignOnServiceLocation(LOCATION);
        }).build();
        return ((Saml2PostAuthenticationRequest.Builder)Saml2PostAuthenticationRequest.withRelyingPartyRegistration((RelyingPartyRegistration)registration).samlRequest(SAML_REQUEST)).build();
    }
}

