/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.revocation;

import java.util.UUID;
import org.apache.nifi.web.security.jwt.revocation.JwtRevocationService;
import org.apache.nifi.web.security.jwt.revocation.JwtRevocationValidator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;

@RunWith(value=MockitoJUnitRunner.class)
public class JwtRevocationValidatorTest {
    private static final String ID = UUID.randomUUID().toString();
    private static final String TOKEN = "TOKEN";
    private static final String TYPE_FIELD = "typ";
    private static final String JWT_TYPE = "JWT";
    @Mock
    private JwtRevocationService jwtRevocationService;
    private Jwt jwt;
    private JwtRevocationValidator validator;

    @Before
    public void setValidator() {
        this.validator = new JwtRevocationValidator(this.jwtRevocationService);
        this.jwt = Jwt.withTokenValue((String)TOKEN).header(TYPE_FIELD, (Object)JWT_TYPE).jti(ID).build();
    }

    @Test
    public void testValidateSuccess() {
        Mockito.when((Object)this.jwtRevocationService.isRevoked((String)ArgumentMatchers.eq((Object)ID))).thenReturn((Object)false);
        OAuth2TokenValidatorResult result = this.validator.validate(this.jwt);
        Assert.assertFalse((boolean)result.hasErrors());
    }

    @Test
    public void testValidateFailure() {
        Mockito.when((Object)this.jwtRevocationService.isRevoked((String)ArgumentMatchers.eq((Object)ID))).thenReturn((Object)true);
        OAuth2TokenValidatorResult result = this.validator.validate(this.jwt);
        Assert.assertTrue((boolean)result.hasErrors());
    }
}

