/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.resolver;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.nifi.web.security.http.SecurityCookieName;
import org.apache.nifi.web.security.http.SecurityHeader;
import org.apache.nifi.web.security.jwt.resolver.StandardBearerTokenResolver;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class StandardBearerTokenResolverTest {
    private static final String BEARER_TOKEN = "TOKEN";
    private StandardBearerTokenResolver resolver;
    @Mock
    private HttpServletRequest request;

    @Before
    public void setResolver() {
        this.resolver = new StandardBearerTokenResolver();
    }

    @Test
    public void testResolveAuthorizationHeaderFound() {
        this.setHeader(String.format("Bearer %s", BEARER_TOKEN));
        Assert.assertEquals((Object)BEARER_TOKEN, (Object)this.resolver.resolve(this.request));
    }

    @Test
    public void testResolveAuthorizationHeaderMissingPrefix() {
        this.setHeader(BEARER_TOKEN);
        Assert.assertNull((Object)this.resolver.resolve(this.request));
    }

    @Test
    public void testResolveAuthorizationHeaderIncorrectPrefix() {
        this.setHeader(String.format("Basic %s", BEARER_TOKEN));
        Assert.assertNull((Object)this.resolver.resolve(this.request));
    }

    @Test
    public void testResolveCookieFound() {
        Cookie cookie = new Cookie(SecurityCookieName.AUTHORIZATION_BEARER.getName(), BEARER_TOKEN);
        Mockito.when((Object)this.request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
        Assert.assertEquals((Object)BEARER_TOKEN, (Object)this.resolver.resolve(this.request));
    }

    private void setHeader(String header) {
        Mockito.when((Object)this.request.getHeader((String)ArgumentMatchers.eq((Object)SecurityHeader.AUTHORIZATION.getHeader()))).thenReturn((Object)header);
    }
}

